package com.biz.crm.dms.business.order.config.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVo;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigDto;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigPageDto;
import com.biz.crm.dms.business.order.config.sdk.service.OrderConfigVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 订单配置管理: OrderConfigVo: 订单配置
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Slf4j
@RestController
@RequestMapping("/v1/orderConfig/orderConfig")
@Api(tags = "订单配置: OrderConfigVo: 订单配置")
public class OrderConfigVoController {

  @Autowired(required = false)
  private OrderConfigVoService orderConfigVoService;

  /**
   * 获取订单配置分页列表
   *
   * @param pageable 分页信息
   * @param dto      请求参数dto
   * @return Page<OrderConfigVo> 普通订单配置分页信息
   */
  @ApiOperation(value = "获取订单配置分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<OrderConfigVo>> findByConditions(@PageableDefault(50) Pageable pageable, @ApiParam(name = "orderConfigPageDto", value = "分页Dto") OrderConfigPageDto dto) {
    try {
      return Result.ok(this.orderConfigVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过ID获取订单配置
   *
   * @param id 订单配置ID
   * @return 订单配置
   */
  @ApiOperation(value = "通过ID获取订单配置")
  @GetMapping("/findById")
  public Result<OrderConfigVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.orderConfigVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param orderConfigDto
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<?> create(@RequestBody OrderConfigDto orderConfigDto) {
    try {
      this.orderConfigVoService.create(orderConfigDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param orderConfigDto
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<?> update(@RequestBody OrderConfigDto orderConfigDto) {
    try {
      this.orderConfigVoService.update(orderConfigDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result<?> enable(@RequestParam("ids") List<String> ids) {
    try {
      this.orderConfigVoService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result<?> disable(@RequestParam("ids") List<String> ids) {
    try {
      this.orderConfigVoService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result<?> delete(@RequestParam("ids") List<String> ids) {
    try {
      this.orderConfigVoService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
