package com.biz.crm.dms.business.order.config.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVo;
import com.biz.crm.dms.business.order.config.local.entity.OrderConfigEntity;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigDto;
import org.apache.ibatis.annotations.Param;

/**
 * 订单配置表的mybatis-plus接口类 {@link OrderConfigEntity}
 *
 * @author pengxi
 * @date 2021/12/30
 */
public interface OrderConfigMapper extends BaseMapper<OrderConfigEntity> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<OrderConfigVo> findByConditions(Page<OrderConfigDto> page, @Param("dto") OrderConfigDto dto);

}

