package com.biz.crm.dms.business.order.config.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigDimensionVo;
import com.biz.crm.dms.business.order.config.local.entity.OrderConfigDimensionEntity;
import com.biz.crm.dms.business.order.config.local.mapper.OrderConfigDimensionMapper;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigDimensionDto;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * 订单配置生效维度表的数据库访问类 {@link OrderConfigDimensionEntity}
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Component
public class OrderConfigDimensionRepository extends ServiceImpl<OrderConfigDimensionMapper, OrderConfigDimensionEntity> {

  /**
   * 列表
   *
   * @param dto
   * @return
   */
  public List<OrderConfigDimensionVo> findByConditions(OrderConfigDimensionDto dto) {
    dto = Optional.ofNullable(dto).orElse(new OrderConfigDimensionDto());
    return baseMapper.findByConditions(dto);
  }

  /**
   * 根据订单配置编码获取详情
   *
   * @param tenantCode 租户编码
   * @param orderType 订单类型
   * @param type 类型
   * @param codes 编码
   * @return OrderConfigDimensionEntity
   */
  public List<OrderConfigDimensionEntity> findByOrderTypeAndTypeAndCodeIn(String tenantCode, String orderType, String type, Collection<String> codes) {
    LambdaQueryWrapper<OrderConfigDimensionEntity> wrapper = Wrappers.lambdaQuery();
    wrapper.eq(OrderConfigDimensionEntity::getTenantCode, tenantCode);
    wrapper.eq(OrderConfigDimensionEntity::getOrderType, orderType);
    wrapper.eq(OrderConfigDimensionEntity::getType, type);
    wrapper.in(OrderConfigDimensionEntity::getCode, codes);
    return this.baseMapper.selectList(wrapper);
  }

  /**
   * 根据订单配置编码删除
   *
   * @param tenantCode 租户编码
   * @param configCodes 订单配置编码集合
   */
  public void deleteByConfigCode(String tenantCode, Set<String> configCodes) {
    this.lambdaUpdate()
        .eq(OrderConfigDimensionEntity::getTenantCode, tenantCode)
        .in(OrderConfigDimensionEntity::getConfigCode, configCodes)
        .remove();
  }
}
