package com.biz.crm.dms.business.order.config.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVerificationVo;
import com.biz.crm.dms.business.order.config.local.entity.OrderConfigVerificationEntity;
import com.biz.crm.dms.business.order.config.local.mapper.OrderVerificationMapper;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigVerificationDto;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * 订单配置校验表的数据库访问类 {@link OrderConfigVerificationEntity}
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Component
public class OrderVerificationRepository extends ServiceImpl<OrderVerificationMapper, OrderConfigVerificationEntity> {

  /**
   * 列表
   *
   * @param dto
   * @return
   */
  public List<OrderConfigVerificationVo> findByConditions(OrderConfigVerificationDto dto) {
    dto = Optional.ofNullable(dto).orElse(new OrderConfigVerificationDto());
    return baseMapper.findByConditions(dto);
  }

  /**
   * 根据订单配置编码集合获取详情
   *
   * @param tenantCode 租户编码
   * @param configCodes 订单配置编码计划
   * @return List<OrderConfigVerificationEntity>
   */
  public List<OrderConfigVerificationEntity> findByConfigCodeIn(String tenantCode, List<String> configCodes) {
    LambdaQueryWrapper<OrderConfigVerificationEntity> wrapper = Wrappers.lambdaQuery();
    wrapper.eq(OrderConfigVerificationEntity::getTenantCode, tenantCode);
    wrapper.in(OrderConfigVerificationEntity::getConfigCode, configCodes);
    return this.baseMapper.selectList(wrapper);
  }

  /**
   * 根据订单配置编码删除
   *
   * @param tenantCode 租户编码
   * @param configCodes 订单配置编码集合
   */
  public void deleteByConfigCode(String tenantCode, Set<String> configCodes) {
    this.lambdaUpdate()
        .eq(OrderConfigVerificationEntity::getTenantCode, tenantCode)
        .in(OrderConfigVerificationEntity::getConfigCode, configCodes)
        .remove();
  }
}
