/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.config.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigDimensionVo;
import com.biz.crm.dms.business.order.config.local.entity.OrderConfigDimensionEntity;
import com.biz.crm.dms.business.order.config.local.mapper.OrderConfigDimensionMapper;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigDimensionDto;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class OrderConfigDimensionRepository
extends ServiceImpl<OrderConfigDimensionMapper, OrderConfigDimensionEntity> {
    public List<OrderConfigDimensionVo> findByConditions(OrderConfigDimensionDto dto) {
        dto = Optional.ofNullable(dto).orElse(new OrderConfigDimensionDto());
        return ((OrderConfigDimensionMapper)this.baseMapper).findByConditions(dto);
    }

    public List<OrderConfigDimensionEntity> findByOrderTypeAndTypeAndCodeIn(String tenantCode, String orderType, String type, Collection<String> codes) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(OrderConfigDimensionEntity::getOrderType, (Object)orderType);
        wrapper.eq(OrderConfigDimensionEntity::getType, (Object)type);
        wrapper.in(OrderConfigDimensionEntity::getCode, codes);
        return ((OrderConfigDimensionMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public void deleteByConfigCode(String tenantCode, Set<String> configCodes) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(OrderConfigDimensionEntity::getConfigCode, configCodes)).remove();
    }
}

