/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.config.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVerificationVo;
import com.biz.crm.dms.business.order.config.local.entity.OrderConfigVerificationEntity;
import com.biz.crm.dms.business.order.config.local.mapper.OrderVerificationMapper;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigVerificationDto;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class OrderVerificationRepository
extends ServiceImpl<OrderVerificationMapper, OrderConfigVerificationEntity> {
    public List<OrderConfigVerificationVo> findByConditions(OrderConfigVerificationDto dto) {
        dto = Optional.ofNullable(dto).orElse(new OrderConfigVerificationDto());
        return ((OrderVerificationMapper)this.baseMapper).findByConditions(dto);
    }

    public List<OrderConfigVerificationEntity> findByConfigCodeIn(String tenantCode, List<String> configCodes) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantEntity::getTenantCode, (Object)tenantCode);
        wrapper.in(OrderConfigVerificationEntity::getConfigCode, configCodes);
        return ((OrderVerificationMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public void deleteByConfigCode(String tenantCode, Set<String> configCodes) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(OrderConfigVerificationEntity::getConfigCode, configCodes)).remove();
    }
}

