/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.config.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigDimensionVo;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVerificationVo;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVo;
import com.biz.crm.dms.business.order.config.local.entity.OrderConfigDimensionEntity;
import com.biz.crm.dms.business.order.config.local.entity.OrderConfigEntity;
import com.biz.crm.dms.business.order.config.local.entity.OrderConfigVerificationEntity;
import com.biz.crm.dms.business.order.config.local.repository.OrderConfigDimensionRepository;
import com.biz.crm.dms.business.order.config.local.repository.OrderConfigRepository;
import com.biz.crm.dms.business.order.config.local.repository.OrderConfigVoRepository;
import com.biz.crm.dms.business.order.config.local.repository.OrderVerificationRepository;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigDimensionDto;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigDto;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigPageDto;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigVerificationDto;
import com.biz.crm.dms.business.order.config.sdk.enums.EffectiveDimensionEnum;
import com.biz.crm.dms.business.order.config.sdk.service.OrderConfigVoService;
import com.biz.crm.dms.business.order.verification.sdk.dto.OrderValidateDetailDto;
import com.biz.crm.dms.business.order.verification.sdk.dto.OrderValidateDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderConfigVoServiceImpl
implements OrderConfigVoService {
    private static final Logger log = LoggerFactory.getLogger(OrderConfigVoServiceImpl.class);
    @Autowired(required=false)
    private OrderConfigRepository orderConfigRepository;
    @Autowired(required=false)
    private OrderConfigVoRepository orderConfigVoRepository;
    @Autowired(required=false)
    private OrderVerificationRepository orderVerificationRepository;
    @Autowired(required=false)
    private OrderConfigDimensionRepository orderConfigDimensionRepository;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public Page<OrderConfigVo> findByConditions(Pageable pageable, OrderConfigPageDto dto) {
        HashSet<String> codes = new HashSet<String>();
        if (Objects.nonNull(dto.getIsDefault()) && !dto.getIsDefault().booleanValue()) {
            OrderConfigDimensionDto orderConfigDimensionDto = new OrderConfigDimensionDto();
            if (StringUtils.isNotBlank((CharSequence)dto.getCustomerCode())) {
                codes.add(dto.getCustomerCode());
                CustomerVo customerVo = this.findByCustomerCode(dto.getCustomerCode());
                if (customerVo != null && StringUtils.isNotBlank((CharSequence)customerVo.getOrgCode())) {
                    codes.add(customerVo.getOrgCode());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getOrgCode())) {
                codes.add(dto.getOrgCode());
            }
            if (CollectionUtils.isNotEmpty(codes)) {
                orderConfigDimensionDto.setCodes(codes);
                List<OrderConfigDimensionVo> orderConfigDimensionVoList = this.orderConfigDimensionRepository.findByConditions(orderConfigDimensionDto);
                Set configCodes = orderConfigDimensionVoList.stream().map(OrderConfigDimensionVo::getConfigCode).collect(Collectors.toSet());
                dto.setConfigCodes(configCodes);
            }
        }
        OrderConfigDto orderConfigDto = new OrderConfigDto();
        orderConfigDto.setOrderType(dto.getOrderType());
        orderConfigDto.setIsDefault(dto.getIsDefault());
        orderConfigDto.setConfigCodes(dto.getConfigCodes());
        return this.orderConfigVoRepository.findByConditions(pageable, orderConfigDto);
    }

    public OrderConfigVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        OrderConfigEntity entity = (OrderConfigEntity)((Object)this.orderConfigRepository.getById((Serializable)((Object)id)));
        if (entity == null) {
            return null;
        }
        OrderConfigVo orderConfigVo = (OrderConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, OrderConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<OrderConfigVerificationEntity> verificationEntities = this.orderVerificationRepository.findByConfigCodeIn(TenantUtils.getTenantCode(), Collections.singletonList(orderConfigVo.getConfigCode()));
        if (CollectionUtils.isNotEmpty(verificationEntities)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(verificationEntities, OrderConfigVerificationEntity.class, OrderConfigVerificationVo.class, HashSet.class, ArrayList.class, new String[0]);
            orderConfigVo.setVerificationVoList(voList);
        }
        OrderConfigDimensionDto orderConfigDimensionDto = new OrderConfigDimensionDto();
        orderConfigDimensionDto.setTenantCode(orderConfigVo.getTenantCode());
        orderConfigDimensionDto.setConfigCode(orderConfigVo.getConfigCode());
        List<OrderConfigDimensionVo> orderConfigDimensionVoList = this.orderConfigDimensionRepository.findByConditions(orderConfigDimensionDto);
        if (CollectionUtils.isNotEmpty(orderConfigDimensionVoList)) {
            List codes = orderConfigDimensionVoList.stream().map(OrderConfigDimensionVo::getCode).collect(Collectors.toList());
            if (EffectiveDimensionEnum.CUSTOMER.getDictCode().equals(orderConfigVo.getEffectiveType())) {
                List customerVos = this.customerVoService.findByCustomerCodes(codes);
                Map customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
                orderConfigDimensionVoList.forEach(ocd -> {
                    CustomerVo customerVo = (CustomerVo)customerVoMap.get(ocd.getCode());
                    if (customerVo == null) {
                        return;
                    }
                    ocd.setName(customerVo.getCustomerName());
                });
            } else if (EffectiveDimensionEnum.ORG.getDictCode().equals(orderConfigVo.getEffectiveType())) {
                List orgVos = this.orgVoService.findByOrgCodes(codes);
                Map orgVoMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
                orderConfigDimensionVoList.forEach(ocd -> {
                    OrgVo orgVo = (OrgVo)orgVoMap.get(ocd.getCode());
                    if (orgVo == null) {
                        return;
                    }
                    ocd.setName(orgVo.getOrgName());
                });
            }
        }
        orderConfigVo.setDimensionVoList(orderConfigDimensionVoList);
        return orderConfigVo;
    }

    @Transactional
    public void create(OrderConfigDto dto) {
        this.createValidation(dto);
        if (StringUtils.isBlank((CharSequence)dto.getConfigCode())) {
            List codeList = this.generateCodeService.generateCode("OC", 1);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)codeList), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u751f\u6210\u8ba2\u5355\u914d\u7f6e\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
            OrderConfigEntity dbEntity = this.orderConfigRepository.findByConfigCode(TenantUtils.getTenantCode(), (String)codeList.get(0));
            Validate.isTrue((boolean)Objects.isNull((Object)dbEntity), (String)String.format("\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8ba2\u5355\u914d\u7f6e\u7f16\u7801[%s]\u5df2\u5b58\u5728\uff01", codeList.get(0)), (Object[])new Object[0]);
            dto.setConfigCode((String)codeList.get(0));
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        } else {
            OrderConfigEntity dbEntity = this.orderConfigRepository.findByConfigCode(TenantUtils.getTenantCode(), dto.getConfigCode());
            Validate.isTrue((boolean)Objects.isNull((Object)dbEntity), (String)String.format("\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8ba2\u5355\u914d\u7f6e\u7f16\u7801[%s]\u5df2\u5b58\u5728\uff01", dto.getConfigCode()), (Object[])new Object[0]);
        }
        OrderConfigEntity entity = (OrderConfigEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, OrderConfigEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.orderConfigRepository.save((Object)entity);
        this.saveBatchVerification(entity, dto.getVerificationDtoList());
        this.saveBatchDimension(entity, dto.getDimensionDtoList());
    }

    @Transactional
    public void update(OrderConfigDto dto) {
        this.updateValidation(dto);
        OrderConfigEntity oldEntity = (OrderConfigEntity)((Object)this.orderConfigRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)oldEntity), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        OrderConfigEntity entity = (OrderConfigEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, OrderConfigEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.orderConfigRepository.updateById((Object)entity);
        this.orderVerificationRepository.deleteByConfigCode(entity.getTenantCode(), Sets.newHashSet((Object[])new String[]{entity.getConfigCode()}));
        this.saveBatchVerification(entity, dto.getVerificationDtoList());
        this.orderConfigDimensionRepository.deleteByConfigCode(entity.getTenantCode(), Sets.newHashSet((Object[])new String[]{entity.getConfigCode()}));
        this.saveBatchDimension(entity, dto.getDimensionDtoList());
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<OrderConfigEntity> entities = this.orderConfigRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.orderConfigRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<OrderConfigEntity> entities = this.orderConfigRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.orderConfigRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<OrderConfigEntity> entities = this.orderConfigRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.orderConfigRepository.updateDelFlagByIds(ids);
        Set<String> orderConfigCodes = entities.stream().map(OrderConfigEntity::getConfigCode).collect(Collectors.toSet());
        this.orderVerificationRepository.deleteByConfigCode(TenantUtils.getTenantCode(), orderConfigCodes);
        this.orderConfigDimensionRepository.deleteByConfigCode(TenantUtils.getTenantCode(), orderConfigCodes);
    }

    private CustomerVo findByCustomerCode(String customerCode) {
        try {
            return this.customerVoService.findDetailsByIdOrCode(null, customerCode);
        }
        catch (Exception e) {
            log.error("Feign\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public OrderConfigVo findByDefaultAndOrderType(String orderType) {
        if (StringUtils.isBlank((CharSequence)orderType)) {
            return null;
        }
        OrderConfigEntity entity = this.orderConfigRepository.findByDefaultAndOrderType(TenantUtils.getTenantCode(), orderType);
        if (entity == null) {
            return null;
        }
        return (OrderConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, OrderConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void saveBatchVerification(OrderConfigEntity entity, List<OrderConfigVerificationDto> verificationDtoList) {
        if (CollectionUtils.isEmpty(verificationDtoList)) {
            return;
        }
        ArrayList orderVerificationEntities = Lists.newArrayList();
        verificationDtoList.forEach(d -> {
            OrderConfigVerificationEntity verificationEntity = new OrderConfigVerificationEntity();
            verificationEntity.setTenantCode(entity.getTenantCode());
            verificationEntity.setConfigCode(entity.getConfigCode());
            Validate.notBlank((CharSequence)d.getName(), (String)"\u8ba2\u5355\u6821\u9a8c\u7b56\u7565\u5b9e\u73b0\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)d.getTitle(), (String)"\u8ba2\u5355\u6821\u9a8c\u7b56\u7565\u5b9e\u73b0\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            verificationEntity.setName(d.getName());
            verificationEntity.setTitle(d.getTitle());
            verificationEntity.setIsOpen(d.getIsOpen());
            orderVerificationEntities.add(verificationEntity);
        });
        if (CollectionUtils.isNotEmpty((Collection)orderVerificationEntities)) {
            this.orderVerificationRepository.saveBatch(orderVerificationEntities);
        }
    }

    private void saveBatchDimension(OrderConfigEntity entity, List<OrderConfigDimensionDto> dimensionDtoList) {
        if (CollectionUtils.isEmpty(dimensionDtoList)) {
            return;
        }
        ArrayList orderConfigDimensionEntities = Lists.newArrayList();
        dimensionDtoList.forEach(d -> {
            Validate.notBlank((CharSequence)d.getCode(), (String)"\u8ba2\u5355\u751f\u6548\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            OrderConfigDimensionEntity dimensionEntity = new OrderConfigDimensionEntity();
            dimensionEntity.setTenantCode(entity.getTenantCode());
            dimensionEntity.setConfigCode(entity.getConfigCode());
            dimensionEntity.setOrderType(entity.getOrderType());
            dimensionEntity.setType(entity.getEffectiveType());
            dimensionEntity.setCode(d.getCode());
            orderConfigDimensionEntities.add(dimensionEntity);
        });
        if (CollectionUtils.isNotEmpty((Collection)orderConfigDimensionEntities)) {
            this.orderConfigDimensionRepository.saveBatch(orderConfigDimensionEntities);
        }
    }

    private void createValidation(OrderConfigDto dto) {
        dto.setId(null);
        this.validation(dto);
    }

    private void updateValidation(OrderConfigDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getConfigCode(), (String)"\u8ba2\u5355\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validation(dto);
    }

    private void validation(OrderConfigDto dto) {
        Validate.notBlank((CharSequence)dto.getOrderType(), (String)"\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getIsDefault(), (String)"\u662f\u5426\u9ed8\u8ba4\u8bbe\u5b9a\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getVerificationDtoList(), (String)"\u8ba2\u5355\u914d\u7f6e\u6821\u9a8c\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrderTypeEnum orderTypeEnum = OrderTypeEnum.findByCode((String)dto.getOrderType());
        Validate.notNull((Object)orderTypeEnum, (String)"\u8ba2\u5355\u7c7b\u578b\u4e0d\u6b63\u786e", (Object[])new Object[0]);
        if (dto.getIsDefault().booleanValue()) {
            OrderConfigVo orderConfigVo = this.findByDefaultAndOrderType(dto.getOrderType());
            Validate.isTrue((Objects.isNull(orderConfigVo) || orderConfigVo.getId().equals(dto.getId()) ? 1 : 0) != 0, (String)String.format("%s\u7c7b\u578b\u5df2\u5b58\u5728\u9ed8\u8ba4\u914d\u7f6e\uff0c\u8bf7\u52ff\u91cd\u590d\u8bbe\u7f6e", orderTypeEnum.getValue()), (Object[])new Object[0]);
        } else {
            Validate.notBlank((CharSequence)dto.getEffectiveType(), (String)"\u751f\u6548\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            EffectiveDimensionEnum effectiveDimensionEnum = EffectiveDimensionEnum.findByCode((String)dto.getEffectiveType());
            Validate.notNull((Object)effectiveDimensionEnum, (String)"\u751f\u6548\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u5ba2\u6237 customer\uff1b\u7ec4\u7ec7 org", (Object[])new Object[0]);
            Validate.notEmpty((Collection)dto.getDimensionDtoList(), (String)"\u975e\u9ed8\u8ba4\u8bbe\u5b9a\u65f6\u751f\u6548\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Set codes = dto.getDimensionDtoList().stream().map(OrderConfigDimensionDto::getCode).collect(Collectors.toSet());
            OrderConfigDimensionDto orderConfigDimensionDto = new OrderConfigDimensionDto();
            orderConfigDimensionDto.setTenantCode(TenantUtils.getTenantCode());
            orderConfigDimensionDto.setCodes(codes);
            List<OrderConfigDimensionVo> orderConfigDimensionVoList = this.orderConfigDimensionRepository.findByConditions(orderConfigDimensionDto);
            ArrayList existConfigList = Lists.newArrayList();
            orderConfigDimensionVoList.forEach(ocd -> {
                if (!ocd.getConfigCode().equals(dto.getConfigCode()) && ocd.getOrderType().equals(dto.getOrderType()) && codes.contains(ocd.getCode())) {
                    existConfigList.add(ocd);
                }
            });
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)existConfigList), (String)"\u5f53\u524d\u8ba2\u5355\u7c7b\u578b\u5df2\u5b58\u5728\u5305\u542b\u751f\u6548\u8303\u56f4\u7684\u914d\u7f6e\u4fe1\u606f\uff08\u5305\u62ec\u7981\u7528\u72b6\u6001\uff09\uff01", (Object[])new Object[0]);
        }
        OrderValidateDto orderValidateDto = (OrderValidateDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, OrderValidateDto.class, HashSet.class, ArrayList.class, new String[0]);
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getVerificationDtoList(), OrderConfigVerificationDto.class, OrderValidateDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        orderValidateDto.setDetailDtoList(voList);
    }
}

