/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.config.local.service.internal;

import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVerificationVo;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVo;
import com.biz.crm.dms.business.order.config.local.entity.OrderConfigDimensionEntity;
import com.biz.crm.dms.business.order.config.local.entity.OrderConfigEntity;
import com.biz.crm.dms.business.order.config.local.entity.OrderConfigVerificationEntity;
import com.biz.crm.dms.business.order.config.local.repository.OrderConfigDimensionRepository;
import com.biz.crm.dms.business.order.config.local.repository.OrderConfigRepository;
import com.biz.crm.dms.business.order.config.local.repository.OrderVerificationRepository;
import com.biz.crm.dms.business.order.config.sdk.enums.EffectiveDimensionEnum;
import com.biz.crm.dms.business.order.config.sdk.service.OrderValidateVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class OrderValidateVoServiceImpl
implements OrderValidateVoService {
    private static final Logger log = LoggerFactory.getLogger(OrderValidateVoServiceImpl.class);
    @Autowired(required=false)
    private OrderConfigRepository orderConfigRepository;
    @Autowired(required=false)
    private OrderVerificationRepository orderVerificationRepository;
    @Autowired(required=false)
    private OrderConfigDimensionRepository orderConfigDimensionRepository;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    private CustomerVo findByCustomerCode(String customerCode) {
        try {
            return this.customerVoService.findDetailsByIdOrCode(null, customerCode);
        }
        catch (Exception e) {
            log.error("Feign\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public OrderConfigVo findByOrderTypeAndCustomerCode(String orderType, String customerCode) {
        List<OrderConfigDimensionEntity> orgList;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{orderType, customerCode})) {
            return null;
        }
        OrderConfigVo orderConfigVo = null;
        List<OrderConfigDimensionEntity> customerList = this.orderConfigDimensionRepository.findByOrderTypeAndTypeAndCodeIn(TenantUtils.getTenantCode(), orderType, EffectiveDimensionEnum.CUSTOMER.getDictCode(), Collections.singleton(customerCode));
        if (CollectionUtils.isNotEmpty(customerList)) {
            orderConfigVo = this.findByConfigDimension(customerList);
        }
        if (orderConfigVo != null) {
            return orderConfigVo;
        }
        CustomerVo customerVo = this.findByCustomerCode(customerCode);
        if (customerVo != null && StringUtils.isNotBlank((CharSequence)customerVo.getOrgCode()) && CollectionUtils.isNotEmpty(orgList = this.orderConfigDimensionRepository.findByOrderTypeAndTypeAndCodeIn(TenantUtils.getTenantCode(), orderType, EffectiveDimensionEnum.ORG.getDictCode(), Collections.singleton(customerVo.getOrgCode())))) {
            orderConfigVo = this.findByConfigDimension(orgList);
        }
        if (orderConfigVo != null) {
            return orderConfigVo;
        }
        OrderConfigEntity orderConfigEntity = this.orderConfigRepository.findByDefaultAndOrderType(TenantUtils.getTenantCode(), orderType);
        if (orderConfigEntity == null) {
            return null;
        }
        orderConfigVo = (OrderConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)orderConfigEntity, OrderConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<OrderConfigVerificationEntity> verificationEntities = this.orderVerificationRepository.findByConfigCodeIn(TenantUtils.getTenantCode(), Collections.singletonList(orderConfigEntity.getConfigCode()));
        if (CollectionUtils.isNotEmpty(verificationEntities)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(verificationEntities, OrderConfigVerificationEntity.class, OrderConfigVerificationVo.class, HashSet.class, ArrayList.class, new String[0]);
            orderConfigVo.setVerificationVoList(voList);
        }
        return orderConfigVo;
    }

    private OrderConfigVo findByConfigDimension(List<OrderConfigDimensionEntity> customerList) {
        if (CollectionUtils.isEmpty(customerList)) {
            return null;
        }
        List<String> configCodes = customerList.stream().map(OrderConfigDimensionEntity::getConfigCode).distinct().collect(Collectors.toList());
        OrderConfigEntity orderConfigEntity = this.orderConfigRepository.findByConfigCode(TenantUtils.getTenantCode(), (String)configCodes.get(0));
        if (orderConfigEntity == null) {
            return null;
        }
        OrderConfigVo orderConfigVo = (OrderConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)orderConfigEntity, OrderConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<OrderConfigVerificationEntity> verificationEntities = this.orderVerificationRepository.findByConfigCodeIn(TenantUtils.getTenantCode(), configCodes);
        if (CollectionUtils.isNotEmpty(verificationEntities)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(verificationEntities, OrderConfigVerificationEntity.class, OrderConfigVerificationVo.class, HashSet.class, ArrayList.class, new String[0]);
            orderConfigVo.setVerificationVoList(voList);
        }
        return orderConfigVo;
    }
}

