package com.biz.crm.dms.business.order.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 订单配置实体类
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@Setter
@ApiModel(value = "OrderConfigEntity", description = "订单配置实体类")
@Entity
@TableName("dms_order_config")
@Table(name = "dms_order_config",
    indexes = {@Index(columnList = "tenant_code , config_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_order_config", comment = "订单配置实体类")
public class OrderConfigEntity extends TenantFlagOpEntity {
  private static final long serialVersionUID = 359185242994872662L;

  /**
   * 订单配置编码
   */
  @ApiModelProperty("订单配置编码")
  @Column(name = "config_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '订单配置编码'")
  private String configCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  @Column(name = "order_type", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '订单类型'")
  private String orderType;

  /**
   * 是否默认设定
   */
  @ApiModelProperty("是否默认设定")
  @Column(name = "is_default", columnDefinition = "bit(1) NOT NULL COMMENT '是否默认设定'")
  private Boolean isDefault;

  /**
   * 生效类型：客户 customer；组织 org
   */
  @ApiModelProperty("生效类型：客户 customer；组织 org")
  @Column(name = "effective_type", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '生效类型：客户 customer；组织 org'")
  private String effectiveType;

  /**
   * 是否揉价
   */
  @ApiModelProperty("是否揉价")
  @Column(name = "is_kneading_price", columnDefinition = "bit(1) COMMENT '是否揉价'")
  private Boolean isKneadingPrice;

  /**
   * 揉价策略实现类名称
   */
  @ApiModelProperty("揉价策略实现类名称")
  @Column(name = "kneading_price_name", columnDefinition = "VARCHAR(64) COMMENT '揉价策略实现类名称'")
  private String kneadingPriceName;

  /**
   * 是否拆单
   */
  @ApiModelProperty("是否拆单")
  @Column(name = "is_split_order", columnDefinition = "bit(1) COMMENT '是否拆单'")
  private Boolean isSplitOrder;

  /**
   * 拆单策略实现类名称
   */
  @ApiModelProperty("拆单策略实现类名称")
  @Column(name = "split_order_name", columnDefinition = "VARCHAR(64) COMMENT '拆单策略实现类名称'")
  private String splitOrderName;

}
