package com.biz.crm.dms.business.order.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 订单配置校验实体类
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@Setter
@ApiModel(value = "OrderVerificationEntity", description = "订单配置校验实体类")
@Entity
@TableName("dms_order_config_verification")
@Table(name = "dms_order_config_verification", indexes = {@Index(columnList = "tenant_code , config_code, name", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_order_config_verification", comment = "订单配置校验实体类")
public class OrderConfigVerificationEntity extends TenantEntity {
  private static final long serialVersionUID = 7626893789435942449L;

  /**
   * 订单配置编码
   */
  @ApiModelProperty("订单配置编码")
  @Column(name = "config_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '订单配置编码'")
  private String configCode;

  /**
   * 校验策略实现类名称
   */
  @ApiModelProperty("校验策略实现类名称")
  @Column(name = "name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '校验策略实现类名称'")
  private String name;

  /**
   * 校验策略实现类标题
   */
  @ApiModelProperty("校验策略实现类标题")
  @Column(name = "title", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '校验策略实现类标题'")
  private String title;

  /**
   * 是否开启
   */
  @ApiModelProperty("是否开启")
  @Column(name = "is_open", columnDefinition = "bit(1) NOT NULL COMMENT '是否开启'")
  private Boolean isOpen;
}
