package com.biz.crm.dms.business.order.config.sdk.dto;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Getter;
import lombok.Setter;

import java.util.Set;

/**
 * 订单配置生效维度DTO
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@Setter
@ApiModel(value = "OrderConfigDimensionDto", description = "订单配置生效维度DTO")
public class OrderConfigDimensionDto extends TenantVo {

  private static final long serialVersionUID = 7259392831517028244L;

  /**
   * 订单配置编码
   */
  @ApiModelProperty("订单配置编码")
  private String configCode;

  /**
   * 类型：customer（客户）；org（组织）
   */
  @ApiModelProperty("类型：customer（客户）；org（组织）")
  private String type;

  /**
   * 编码
   */
  @ApiModelProperty("编码")
  private String code;

  /**
   * 编码集合
   */
  @ApiModelProperty("编码集合")
  private Set<String> codes;

}
