package com.biz.crm.dms.business.order.config.sdk.dto;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Getter;
import lombok.Setter;

/**
 * 订单配置校验DTO
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@Setter
@ApiModel(value = "OrderVerificationDto", description = "订单配置校验DTO")
public class OrderConfigVerificationDto extends TenantVo {
  private static final long serialVersionUID = 8157799695561914838L;

  /**
   * 订单配置编码
   */
  @ApiModelProperty("订单配置编码")
  private String configCode;

  /**
   * 策略实现名称
   */
  @ApiModelProperty("策略实现名称")
  private String name;

  /**
   * 标题
   */
  @ApiModelProperty("标题")
  private String title;

  /**
   * 是否开启
   */
  @ApiModelProperty("是否开启")
  private Boolean isOpen;

}
