package com.biz.crm.dms.business.order.config.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * 生效维度类型枚举
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@AllArgsConstructor
public enum EffectiveDimensionEnum {
  /**
   * 客户
   */
  CUSTOMER("customer", "customer", "客户", "1"),
  /**
   * 组织
   */
  ORG("org", "org", "组织", "2"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  public static EffectiveDimensionEnum findByCode(String code) {
    Optional<EffectiveDimensionEnum> first = Stream.of(EffectiveDimensionEnum.values()).filter(t -> t.dictCode.equals(code)).findFirst();
    return first.orElse(null);
  }
}
