package com.biz.crm.dms.business.order.config.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVo;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigDto;
import com.biz.crm.dms.business.order.config.sdk.dto.OrderConfigPageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 订单配置Vo服务接口类
 *
 * @author pengxi
 * @date 2021/12/30
 */
public interface OrderConfigVoService {

  /**
   * 订单配置分页查询
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<OrderConfigVo> 普通授信分页信息
   */
  Page<OrderConfigVo> findByConditions(Pageable pageable, OrderConfigPageDto dto);

  /**
   * 根据ID获取订单配置信息
   *
   * @param id 订单配置ID
   * @return OrderConfigVo 订单配置信息
   */
  OrderConfigVo findById(String id);

  /**
   * 创建
   * （1）校验数据重复性时，校验的是新增数据和除本身外的所有数据是否重复，禁用的也要校验，如检测到存在禁用的重复数据，可提示客户启用禁用数据
   * （2）默认配置：将订单类型作为唯一识别码，订单类型一样，则判定一样。
   * （3）非默认配置：将订单类型+客户编码；订单类型+组织编码作为唯一标识不能重复。
   * （4）生效逻辑：订单类型+客户编码>订单类型+组织编码>订单类型（默认配置）
   *
   * @param dto
   */
  void create(OrderConfigDto dto);

  /**
   * 更新
   * （1）校验数据重复性时，校验的是新增数据和除本身外的所有数据是否重复，禁用的也要校验，如检测到存在禁用的重复数据，可提示客户启用禁用数据
   * （2）默认配置：将订单类型作为唯一识别码，订单类型一样，则判定一样。
   * （3）非默认配置：将订单类型+客户编码；订单类型+组织编码作为唯一标识不能重复。
   * （4）生效逻辑：订单类型+客户编码>订单类型+组织编码>订单类型（默认配置）
   *
   * @param dto
   */
  void update(OrderConfigDto dto);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 根据订单类型获取订单默认配置信息
   *
   * @param orderType 订单类型
   * @return OrderConfigVo
   */
  OrderConfigVo findByDefaultAndOrderType(String orderType);
 }
