package com.biz.crm.dms.business.order.config.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Set;

/**
 * 订单配置dto
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@Setter
@ApiModel(value = "OrderConfigDto", description = "订单配置dto")
public class OrderConfigDto extends TenantFlagOpDto {
  /**
   * 订单配置编码集合
   */
  @ApiModelProperty("订单配置编码集合")
  private Set<String> configCodes;

  /**
   * 订单配置编码
   */
  @ApiModelProperty("订单配置编码")
  private String configCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 是否默认设定
   */
  @ApiModelProperty("是否默认设定")
  private Boolean isDefault;

  /**
   * 生效类型：客户 customer；组织 org
   */
  @ApiModelProperty("生效类型：客户 customer；组织 org")
  private String effectiveType;

  /**
   * 是否揉价
   */
  @ApiModelProperty("是否揉价")
  private Boolean isKneadingPrice;

  /**
   * 揉价策略实现类名称
   */
  @ApiModelProperty("揉价策略实现类名称")
  private String kneadingPriceName;

  /**
   * 是否拆单
   */
  @ApiModelProperty("是否拆单")
  private Boolean isSplitOrder;

  /**
   * 拆单策略实现类名称
   */
  @ApiModelProperty("拆单策略实现类名称")
  private String splitOrderName;

  /**
   * 订单配置校验集合DTO
   */
  @ApiModelProperty("订单配置校验集合DTO")
  private List<OrderConfigVerificationDto> verificationDtoList;

  /**
   * 订单配置生效维度集合DTO
   */
  @ApiModelProperty("订单配置生效维度集合DTO")
  private List<OrderConfigDimensionDto> dimensionDtoList;

}

