package com.biz.crm.dms.business.order.config.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Set;

/**
 * 订单配置dto
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@Setter
@ApiModel(value = "OrderConfigDto", description = "订单配置dto")
public class OrderConfigPageDto extends TenantFlagOpDto {

  /**
   * 订单配置编码集合
   */
  @ApiModelProperty("订单配置编码集合")
  private Set<String> configCodes;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 是否默认设定
   */
  @ApiModelProperty("是否默认设定")
  private Boolean isDefault;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

}

