package com.biz.crm.dms.business.order.config.sdk.service;


import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVo;

/**
 * 订单配置校验Vo服务接口类
 *
 * @author pengxi
 * @date 2021/12/30
 */
public interface OrderValidateVoService {

  /**
   * 根据优先级规则获取订单配置信息
   * 第一优先：客户编码
   * 第二优先：客户所属组织
   * 第三优先：默认设置（系统初始化）
   *
   * @param orderType 订单类型
   * @param customerCode 客户编码
   * @return OrderConfigVo
   */
  OrderConfigVo findByOrderTypeAndCustomerCode(String orderType, String customerCode);
}
