package com.biz.crm.dms.business.order.feerate.local.context.feerateelement;

import com.biz.crm.dms.business.order.feerate.sdk.enums.OrderStatisticsElementTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.register.FeeStatisticsRegister;
import com.biz.crm.dms.business.order.feerate.sdk.vo.FeeStatisticsModelVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @description: 费用销售范围上下文
 * @author: rentao
 * @date: 2021/12/30 18:12
 */
@Component
public class FeeStatisticsContext {

  @Autowired(required = false)
  private List<FeeStatisticsRegister> eventListeners;

  /**
   * 得到所有要素
   *
   * @return
   */
  public List<FeeStatisticsModelVo> getAllConfig() {
    List<FeeStatisticsModelVo> list = new ArrayList<>();
    if (CollectionUtils.isNotEmpty(eventListeners)) {
      eventListeners.forEach(
          s -> {
            FeeStatisticsModelVo feeStatisticsModelVo = s.onRequestFeeStatisticsModelVo();
            if(OrderStatisticsElementTypeEnum.SHOW.getKey().equals(feeStatisticsModelVo.getFeeStatisticsStatus())){
              list.add(feeStatisticsModelVo);
            }
          });
    }
    if (CollectionUtils.isNotEmpty(list)) {
      Collections.sort(
          list,
          new Comparator<FeeStatisticsModelVo>() {
            @Override
            public int compare(FeeStatisticsModelVo o1, FeeStatisticsModelVo o2) {
              return o1.getFeeStatisticsSort().compareTo(o2.getFeeStatisticsSort());
            }
          });
    }
    return list;
  }
}
