package com.biz.crm.dms.business.order.feerate.local.context.feerateelement;

import com.biz.crm.dms.business.order.feerate.sdk.enums.OrderStatisticsElementTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.register.SaleStatisticsRegister;
import com.biz.crm.dms.business.order.feerate.sdk.vo.SaleStatisticsModelVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @description: 销售额统计范围
 * @author: rentao
 * @date: 2021/12/30 18:14
 */
@Component
public class SaleStatisticsContext {

  @Autowired(required = false)
  private List<SaleStatisticsRegister> eventListeners;

  /**
   * 得到所有要素
   *
   * @return
   */
  public List<SaleStatisticsModelVo> getAllConfig() {
    List<SaleStatisticsModelVo> list = new ArrayList<>();
    if (CollectionUtils.isNotEmpty(eventListeners)) {
      eventListeners.forEach(
          s -> {
            SaleStatisticsModelVo saleStatisticsModelVo = s.onRequestSaleStatisticsModelVo();
            if(OrderStatisticsElementTypeEnum.SHOW.getKey().equals(saleStatisticsModelVo.getSaleStatisticsStatus())){
              list.add(saleStatisticsModelVo);
            }
          });
    }
    if (CollectionUtils.isNotEmpty(list)) {
      Collections.sort(
          list,
          new Comparator<SaleStatisticsModelVo>() {
            @Override
            public int compare(SaleStatisticsModelVo o1, SaleStatisticsModelVo o2) {
              return o1.getSaleStatisticsSort().compareTo(o2.getSaleStatisticsSort());
            }
          });
    }
    return list;
  }
}
