package com.biz.crm.dms.business.order.feerate.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.feerate.local.entity.DmsFeeRate;
import com.biz.crm.dms.business.order.feerate.local.service.DmsFeeRateService;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 费用比例(DmsFeeRate) 费用比例信息
 *
 * @author rentao
 * @since 2021-12-29 17:53:57
 */
@RestController
@RequestMapping(value = {"/v1/feeRate/feeRate"})
@Slf4j
@Api(tags = "费用比例:FeeRate:费用比例")
public class DmsFeeRateController {

  /** 费用比例 */
  @Autowired(required = false) private DmsFeeRateService dmsFeeRateService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dmsFeeRateDto 查询实体
   */
  @ApiOperation(value = "分页查询")
  @GetMapping("findByConditions")
  public Result<Page<DmsFeeRate>> findByConditions(
      @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "dmsFeeRate", value = "费用比例") DmsFeeRateDto dmsFeeRateDto) {
    try {
      Page<DmsFeeRate> page = this.dmsFeeRateService.findByConditions(pageable, dmsFeeRateDto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "ͨ通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<DmsFeeRate> findById(
      @PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      DmsFeeRate dmsFeeRate = this.dmsFeeRateService.findById(id);
      return Result.ok(dmsFeeRate);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param dmsFeeRateDto 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<DmsFeeRate> create(
      @ApiParam(name = "dmsFeeRateVo", value = "费用比例") @RequestBody DmsFeeRateDto dmsFeeRateDto) {
    try {
      DmsFeeRate result = this.dmsFeeRateService.create(dmsFeeRateDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 编辑数据
   *
   * @param dmsFeeRateDto 实体对象
   * @return 编辑结果
   */
  @ApiOperation(value = "编辑数据")
  @PatchMapping
  public Result<DmsFeeRate> update(
      @ApiParam(name = "dmsFeeRate", value = "费用比例") @RequestBody  DmsFeeRateDto dmsFeeRateDto) {
    try {
      DmsFeeRate result = this.dmsFeeRateService.update(dmsFeeRateDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量删除
   *
   * @param ids
   */
  @ApiOperation(value = "批量删除数据")
  @DeleteMapping
  public Result<?> delete(@RequestParam("ids") List<String> ids) {
    try {
      this.dmsFeeRateService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /** 启用 */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      this.dmsFeeRateService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /** 禁用 */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      this.dmsFeeRateService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
