package com.biz.crm.dms.business.order.feerate.local.controller;

import com.biz.crm.business.common.sdk.model.Result;

import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsOptimalFeePoolRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.service.DmsFeeRateVoService;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 费用比例:FeeRate:费用比例"
 * @author: rentao
 * @date: 2022/2/26 15:51
 */
@RestController
@RequestMapping(value = {"/v1/feeRate/feeRate"})
@Slf4j
@Api(tags = "费用比例:FeeRate:费用比例")
public class DmsFeeRateVoController {

  @Autowired(required = false) private DmsFeeRateVoService dmsFeeRateVoService;

  /**
   * 查询费比配置(最优)
   *
   * @param dmsOptimalFeePoolRateDto
   * @return
   */
  @ApiOperation(value = "费用池查询费比配置(最优)")
  @GetMapping("findOptimalFeeRateVoByFeeRatePoolDto")
  public Result<DmsFeeRateVo> findOptimalFeeRateVoByFeeRatePoolDto(
      @ApiParam(name = "dmsOptimalFeePoolRateDto", value = "费用池比例Dto") DmsOptimalFeePoolRateDto dmsOptimalFeePoolRateDto) {
    try {
      DmsFeeRateVo result = this.dmsFeeRateVoService.findOptimalFeeRateVoByFeeRateDto(dmsOptimalFeePoolRateDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
