package com.biz.crm.dms.business.order.feerate.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.feerate.local.service.DmsSaleStatisticsService;
import com.biz.crm.dms.business.order.feerate.sdk.vo.SaleStatisticsModelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 销售额统计范围:SaleStatisticsModelVo:销售额统计范围
 * @author: rentao
 * @date: 2022/1/3 21:25
 */
@RestController
@RequestMapping(value = {"/v1/saleStatistics/saleStatistics"})
@Slf4j
@Api(tags = "销售额统计范围:SaleStatisticsModelVo:销售额统计范围")
public class DmsSaleStatisticsController {

  @Autowired(required = false)
  private DmsSaleStatisticsService dmsSaleStatisticsService;

  /**
   * 销售额统计范围列表
   *
   * @param
   */
  @ApiOperation(value = "销售额统计范围列表")
  @GetMapping("/findByConditions")
  public Result<List<SaleStatisticsModelVo>> findByConditions() {
    return Result.ok(this.dmsSaleStatisticsService.findByConditions());
  }
}
