package com.biz.crm.dms.business.order.feerate.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 费用使用比例
 * @author: rentao
 * @date: 2021/12/29 16:25
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeeRateEntity", description = "费用使用比例")
@Entity
@TableName("dms_fee_rate")
@Table(name = "dms_fee_rate")
@org.hibernate.annotations.Table(appliesTo = "dms_fee_rate", comment = "费用使用比例")
public class DmsFeeRate extends TenantFlagOpEntity {

  private static final long serialVersionUID = -7023179621026310279L;

  /** 费比类型 0 费用池 1 整单 */
  @ApiModelProperty(name = "feeType", value = "费比类型 0 费用池 1 整单", required = true)
  @Column(
      name = "fee_type",
      nullable = false,
      columnDefinition = "smallint COMMENT '费比类型 0 费用池 1 整单'")
  private Integer feeType;

  /** 费用统计范围编码 */
  @ApiModelProperty(name = "feeStatisticsCode", value = "费用统计范围编码", required = true)
  @Column(
      name = "fee_statistics_code",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '费用统计范围编码'")
  private String feeStatisticsCode;

  /** 费用统计范围名称 */
  @ApiModelProperty(name = "feeStatisticsName", value = "费用统计范围名称", required = true)
  @Column(
      name = "fee_statistics_name",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '费用统计范围名称'")
  private String feeStatisticsName;

  /** 销售额统计范围编码 */
  @ApiModelProperty(name = "saleStatisticsCode", value = "销售额统计范围编码", required = true)
  @Column(
      name = "sale_statistics_code",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '销售额统计范围编码'")
  private String saleStatisticsCode;

  /** 销售额统计范围名称 */
  @ApiModelProperty(name = "saleStatisticsName", value = "销售额统计范围名称", required = true)
  @Column(
      name = "sale_statistics_name",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '销售额统计范围名称'")
  private String saleStatisticsName;

  /** 比例 （%） */
  @ApiModelProperty(name = "janTargetNum", value = "比例 （%）", required = true)
  @Column(
      name = "rate",
      nullable = false,
      columnDefinition = "decimal(20,4) COMMENT '比例 （%）'")
  private BigDecimal rate;

  /** 生效维度 0 客户 1 组织 */
  @ApiModelProperty(name = "demension", value = "生效维度 0 客户 1 组织", required = true)
  @Column(
      name = "demension",
      nullable = false,
      columnDefinition = "smallint COMMENT '生效维度 0 客户 1 组织'")
  private Integer demension;

  /** 生效维度名称 */
  @ApiModelProperty(name = "demensionName", value = "生效维度名称")
  @Column(
      name = "demension_name",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '生效维度名称'")
  private String demensionName;

  /** 业务编码 根据生效维度来的数据必填 */
  @ApiModelProperty(name = "businessCode", value = "业务编码 生效维度为 0 客户 必填")
  @Column(
      name = "business_code",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '业务编码 生效维度为 0 客户 必填'")
  private String businessCode;

  /** 业务名称 根据生效维度来 */
  @ApiModelProperty(name = "businessName", value = "业务名称 生效维度为 0 客户 必填")
  @Column(
      name = "business_name",
      length = 128,
      columnDefinition = "VARCHAR(128)  COMMENT '业务名称 生效维度为 0 客户 必填'")
  private String businessName;
}
