package com.biz.crm.dms.business.order.feerate.local.repository;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.order.feerate.local.entity.DmsFeeRate;
import com.biz.crm.dms.business.order.feerate.local.mapper.DmsFeeRateMapper;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

/**
 * 费用比例(DmsFeeRate)
 *
 * @author rentao
 * @since 2021-12-29 17:53:58
 */
@Component
public class DmsFeeRateRepository extends ServiceImpl<DmsFeeRateMapper, DmsFeeRate> {

  @Autowired(required = false) private DmsFeeRateMapper dmsFeeRateMapper;

  /**
   * 分页查询所有数据
   *
   * @param pageable
   * @param dmsFeeRateDto
   * @author rentao
   * @date
   */
  public Page<DmsFeeRate> findByConditions(Pageable pageable, DmsFeeRateDto dmsFeeRateDto) {
    Page<DmsFeeRate> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<DmsFeeRate> pageList = dmsFeeRateMapper.findByConditions(page, dmsFeeRateDto);
    return pageList;
  }

  /**
   * 根据主键集合，修改 enable_status
   *
   * @param enable
   * @param ids
   */
  public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    this.lambdaUpdate()
        .set(DmsFeeRate::getEnableStatus, enable.getCode())
        .in(DmsFeeRate::getId, ids)
        .update();
  }

  /**
   * 查询所有数据
   *
   * @param dmsFeeRateDto
   * @author rentao
   * @date
   */
  public List<DmsFeeRate> findByConditions(DmsFeeRateDto dmsFeeRateDto) {
    List<DmsFeeRate> list = dmsFeeRateMapper.findByConditions(dmsFeeRateDto);
    return list;
  }
}
