package com.biz.crm.dms.business.order.feerate.local.service.internal;

import com.biz.crm.dms.business.order.feerate.local.service.DmsFeeRateDemensionService;
import com.biz.crm.dms.business.order.feerate.sdk.strategy.DemensionStrategy;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateDemensionVo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 费比销售范围下拉
 * @author: rentao
 * @date: 2022/6/8 16:56
 */
@Service
@Slf4j
public class DmsFeeRateDemensionServiceImpl implements DmsFeeRateDemensionService {

  @Autowired(required = false)
  private List<DemensionStrategy> demensionStrategies;

  @Override
  public List<DmsFeeRateDemensionVo> findByConditions() {
    if(CollectionUtils.isEmpty(demensionStrategies)){
     return null;
    }
    List<DmsFeeRateDemensionVo> list = new ArrayList<>();
    List<DemensionStrategy> demensionStrategieList = demensionStrategies.stream()
        .sorted(Comparator.comparing(DemensionStrategy::getDemensionIndex)).collect(
            Collectors.toList());
    for (DemensionStrategy demensionStrategy : demensionStrategieList) {
      DmsFeeRateDemensionVo dmsFeeRateDemensionVo = new DmsFeeRateDemensionVo();
      dmsFeeRateDemensionVo.setDemension(demensionStrategy.getDemensionCode());
      dmsFeeRateDemensionVo.setDemensionName(demensionStrategy.getDemensionName());
      dmsFeeRateDemensionVo.setDemensonIndex(demensionStrategy.getDemensionIndex());
      list.add(dmsFeeRateDemensionVo);
    }
    return list;
  }
}
