package com.biz.crm.dms.business.order.feerate.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsElementRegister;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsService;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsOptimalFeePoolRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.strategy.DemensionStrategy;
import com.biz.crm.dms.business.order.feerate.sdk.service.DmsFeeRateVerificationService;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.service.DmsFeeRateVoService;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 费比校验 Service
 * @author: rentao
 * @date: 2021/12/30 14:45
 */
@Service
@Slf4j
public class DmsFeeRateVerificationServiceImpl implements DmsFeeRateVerificationService {

  @Autowired(required = false)
  private OrderStatisticsService orderStatisticsService;

  @Autowired(required = false)
  private List<OrderStatisticsElementRegister> orderStatisticsElementRegisterList;

  @Autowired(required = false)
  private List<DemensionStrategy> demensionStrategies;


  /**
   * 费比校验
   *
   * @param orderVerificationContext 订单参数
   * @author rentao
   */
  @Override
  public void handleValidateFeeRateOrderRate(OrderVerificationContext orderVerificationContext,
      FeeTypeEnum feeTypeEnum) {
    Validate.notNull(orderVerificationContext, "订单信息不能为空！");
    OrderDto orderDto = orderVerificationContext.getOrderDto();
    Validate.notNull(feeTypeEnum, "费比类型不能为空！");
    Validate.notNull(orderDto, "费比校验时订单信息不能为空！");
    //获取最优费比
    List<DmsFeeRateVo> dmsFeeRateVos = this.getFeeRateVo(orderDto, feeTypeEnum);
    for (DmsFeeRateVo dmsFeeRateVo : dmsFeeRateVos) {
      String saleStatisticsCodes = dmsFeeRateVo.getSaleStatisticsCode();
      String feeStatisticsCodes = dmsFeeRateVo.getFeeStatisticsCode();
      Set<String> saleStatisticsCodSet = Sets.newHashSet(StringUtils.split(saleStatisticsCodes, "+"));
      Set<String> feeStatisticsCodeSet = Sets.newHashSet(StringUtils.split(feeStatisticsCodes, "+"));
      //通过订单行注册器 拿到值
      List<BigDecimal> saleCountMoneys = this.getFeeCountMoney(saleStatisticsCodSet, orderVerificationContext);
      List<BigDecimal> feeCountMoneys = this.getFeeCountMoney(feeStatisticsCodeSet, orderVerificationContext);
      //统计值
      BigDecimal saleCountMoney = orderStatisticsService.getFeeCount(saleCountMoneys);
      BigDecimal feeCountMoney = orderStatisticsService.getFeeCount(feeCountMoneys);
      //比例
      BigDecimal rate = dmsFeeRateVo.getRate();
      BigDecimal actualRate = saleCountMoney.multiply(rate)
          .divide(BigDecimal.valueOf(100), 4, RoundingMode.HALF_UP);
      Validate.isTrue(feeCountMoney.compareTo(actualRate) <= 0, "费用比例超过%s费比设置比例",feeTypeEnum.getValue());
    }
  }


  /**
   * 拿到最优配置（本品 赠品 本增）
   */
  private List<DmsFeeRateVo> getFeeRateVo(OrderDto orderDto, FeeTypeEnum feeTypeEnum) {
    //查询出各个维度的数据
    Validate.isTrue(!CollectionUtils.isEmpty(demensionStrategies), "获取费比是生效维度注册器不存在！");
    List<DemensionStrategy> demensionStrategieList = demensionStrategies.stream()
        .sorted(Comparator.comparing(DemensionStrategy::getDemensionIndex)).collect(
            Collectors.toList());
    List<DmsFeeRateVo> dmsFeeRateVoList = new ArrayList<>();
    DmsOptimalFeePoolRateDto dmsOptimalFeePoolRateDto = new DmsOptimalFeePoolRateDto();
    dmsOptimalFeePoolRateDto.setBusinessCode(orderDto.getRelateCode());
    for (DemensionStrategy demensionStrategy : demensionStrategieList) {
      List<DmsFeeRateVo> dmsFeeRateVos = demensionStrategy.getByDemension(dmsOptimalFeePoolRateDto, feeTypeEnum);
      if(!CollectionUtils.isEmpty(dmsFeeRateVos)){
        dmsFeeRateVoList.addAll(dmsFeeRateVos);
        break;
      }
    }
    return dmsFeeRateVoList;
  }

  /**
   * 订单行编码获取行金额
   *
   * @param orderStatisticsCodSet
   * @param orderVerificationContext
   * @author rentao
   * @date
   */
  private List<BigDecimal> getFeeCountMoney(Set<String> orderStatisticsCodSet,
      OrderVerificationContext orderVerificationContext) {
    Validate.isTrue(!CollectionUtils.isEmpty(orderStatisticsCodSet), "传入订单统计范围要素为空");
    List<BigDecimal> feeMoneys = new ArrayList<>();
    for (String orderStatisticsElementCode : orderStatisticsCodSet) {
      orderStatisticsElementRegisterList.forEach(orderStatisticsElementRegister -> {
        if (orderStatisticsElementRegister.getOrderStatisticsElementCode()
            .equals(orderStatisticsElementCode)) {
          BigDecimal feeMoney = orderStatisticsElementRegister
              .getFeeMoney(orderVerificationContext);
          feeMoneys.add(feeMoney);
        }
      });
    }
    Validate.isTrue(orderStatisticsCodSet.size() == feeMoneys.size(), "计算金额，传入订单统计范围要素和匹配数量不相等");
    return feeMoneys;
  }
}
