package com.biz.crm.dms.business.order.feerate.local.service.internal;

import com.biz.crm.dms.business.order.feerate.local.entity.DmsFeeRate;
import com.biz.crm.dms.business.order.feerate.local.repository.DmsFeeRateRepository;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsOptimalFeePoolRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.service.DmsFeeRateVoService;
import com.biz.crm.dms.business.order.feerate.sdk.strategy.DemensionStrategy;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @description: 费比配置:DmsFeeRateVo:service
 * @author: rentao
 * @date: 2021/12/30 15:51
 */
@Service
@Slf4j
public class DmsFeeRateVoServiceImpl implements DmsFeeRateVoService {

  @Autowired(required = false) private DmsFeeRateRepository dmsFeeRateRepository;
  @Autowired(required = false) private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false) private CustomerVoService customerVoService;
  @Autowired(required = false)
  private List<DemensionStrategy> demensionStrategies;

  /**
   * 查询费比配置
   *
   * @param dmsFeeRateDto
   * @author rentao
   * @date a
   */
  @Override
  public List<DmsFeeRateVo> findByDmsFeeRateDto(DmsFeeRateDto dmsFeeRateDto) {
    if (Objects.isNull(dmsFeeRateDto)) {
      return null;
    }
    List<DmsFeeRate> dmsFeeRateList = dmsFeeRateRepository.findByConditions(dmsFeeRateDto);
    if(CollectionUtils.isEmpty(dmsFeeRateList)){
      return null;
    }
    List<DmsFeeRateVo> list = (List<DmsFeeRateVo>) this.nebulaToolkitService.copyCollectionByBlankList(dmsFeeRateList
        , DmsFeeRate.class, DmsFeeRateVo.class, HashSet.class, ArrayList.class);
    return list;
  }

  @Override
  public DmsFeeRateVo findOptimalFeeRateVoByFeeRateDto(DmsOptimalFeePoolRateDto dmsOptimalFeeRateDto) {
    Validate.notNull(dmsOptimalFeeRateDto, "订单信息不能为空");
    Validate.notEmpty(dmsOptimalFeeRateDto.getCustomerCode(),"客户编码不能为空");
    Validate.notEmpty(dmsOptimalFeeRateDto.getFeeStatisticsCode(),"费用统计范围编码不能为空");
    dmsOptimalFeeRateDto.setFeeStatisticsCode(dmsOptimalFeeRateDto.getFeeStatisticsCode().replaceAll(" ","+"));
    return this.getFeeRateVo(dmsOptimalFeeRateDto,FeeTypeEnum.FEE_POOL);
  }

  /** 拿到最优配置（本品 赠品 本增） */
  private DmsFeeRateVo getFeeRateVo(DmsOptimalFeePoolRateDto dmsOptimalFeeRateDto,FeeTypeEnum feeTypeEnum) {
    //查询出各个维度的数据
    Validate.isTrue(!CollectionUtils.isEmpty(demensionStrategies), "获取费比是生效维度注册器不存在！");
    List<DemensionStrategy> demensionStrategieList = demensionStrategies.stream()
        .sorted(Comparator.comparing(DemensionStrategy::getDemensionIndex)).collect(
            Collectors.toList());
    List<DmsFeeRateVo> dmsFeeRateVoList = new ArrayList<>();
    for (DemensionStrategy demensionStrategy : demensionStrategieList) {
      List<DmsFeeRateVo> dmsFeeRateVos = demensionStrategy.getByDemension(dmsOptimalFeeRateDto, feeTypeEnum);
      if(!CollectionUtils.isEmpty(dmsFeeRateVos)){
        dmsFeeRateVoList.addAll(dmsFeeRateVos);
        break;
      }
    }
    Validate.isTrue(!CollectionUtils.isEmpty(dmsFeeRateVoList), "没有配置费用比例");
    return dmsFeeRateVoList.get(0);
  }
}
