package com.biz.crm.dms.business.order.feerate.local.service.register.feestatistics;

import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.constant.OrderStatisticsElementConstant;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.enums.OrderStatisticsElementTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.register.FeeStatisticsRegister;
import com.biz.crm.dms.business.order.feerate.sdk.vo.FeeStatisticsModelVo;
import org.springframework.stereotype.Service;

/**
 * @description: 货补 组合注册器实现
 * @author: rentao
 * @date: 2022/1/17 16:15
 */
@Service
public class CompensatedFeeStatisticsRegisterImpl implements FeeStatisticsRegister {

  private static final Integer INDEX_CODE = 1;

  private static final String FEE_STATISTICS_NAME = "货补";


  @Override
  public FeeStatisticsModelVo onRequestFeeStatisticsModelVo() {
    FeeStatisticsModelVo feeStatisticsModelVo = new FeeStatisticsModelVo();
    feeStatisticsModelVo.setFeeStatisticsType(FeeTypeEnum.FEE_POOL.getKey());
    feeStatisticsModelVo.setFeeStatisticsSort(INDEX_CODE);
    feeStatisticsModelVo.setFeeStatisticsCode(OrderStatisticsElementConstant.COMPENSATED_GOODS);
    feeStatisticsModelVo.setFeeStatisticsStatus(OrderStatisticsElementTypeEnum.SHOW.getKey());
    feeStatisticsModelVo.setFeeStatisticsName(FEE_STATISTICS_NAME);
    return feeStatisticsModelVo;
  }
}
