package com.biz.crm.dms.business.order.feerate.local.service.register.feestatistics;

import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.constant.OrderStatisticsElementConstant;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.enums.OrderStatisticsElementTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.register.FeeStatisticsRegister;
import com.biz.crm.dms.business.order.feerate.sdk.vo.FeeStatisticsModelVo;
import org.springframework.stereotype.Service;

/**
 * @description: 政策优惠金额+货补+折扣 组合注册器实现
 * @author: rentao
 * @date: 2022/1/17 16:15
 */
@Service
public class PolicyCompensatDiscountFeeStatisticsRegisterImpl implements FeeStatisticsRegister {

  private static final Integer INDEX_CODE = 2;

  private static final String FEE_STATISTICS_NAME = "政策优惠金额+货补+折扣";

  @Override
  public FeeStatisticsModelVo onRequestFeeStatisticsModelVo() {
    StringBuilder feeStatisticsCode = new StringBuilder();
    feeStatisticsCode.append(OrderStatisticsElementConstant.POLICY_GOODS).append("+")
        .append(OrderStatisticsElementConstant.COMPENSATED_GOODS).append("+")
        .append(OrderStatisticsElementConstant.DISCOUNT_GOODS);
    FeeStatisticsModelVo feeStatisticsModelVo = new FeeStatisticsModelVo();
    feeStatisticsModelVo.setFeeStatisticsType(FeeTypeEnum.ENTIRE_ORDER.getKey());
    feeStatisticsModelVo.setFeeStatisticsSort(INDEX_CODE);
    feeStatisticsModelVo.setFeeStatisticsCode(feeStatisticsCode.toString());
    feeStatisticsModelVo.setFeeStatisticsStatus(OrderStatisticsElementTypeEnum.SHOW.getKey());
    feeStatisticsModelVo.setFeeStatisticsName(FEE_STATISTICS_NAME);
    return feeStatisticsModelVo;
  }
}
