package com.biz.crm.dms.business.order.feerate.local.service.register.salestatistics;

import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.constant.OrderStatisticsElementConstant;
import com.biz.crm.dms.business.order.feerate.sdk.enums.OrderStatisticsElementTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.register.SaleStatisticsRegister;
import com.biz.crm.dms.business.order.feerate.sdk.vo.SaleStatisticsModelVo;
import org.springframework.stereotype.Service;

/**
 * @description: 本增 组合注册器实现
 * @author: rentao
 * @date: 2022/1/17 14:14
 */
@Service
public class NormalComplimentSaleStatisticsRegisterImpl implements SaleStatisticsRegister {

  private static final Integer INDEX_CODE = 2;

  private static final String SALE_STATISTICS_NAME = "本品+赠品";

  @Override
  public SaleStatisticsModelVo onRequestSaleStatisticsModelVo() {
    SaleStatisticsModelVo saleStatisticsModelVo = new SaleStatisticsModelVo();
    saleStatisticsModelVo.setSaleStatisticsSort(INDEX_CODE);
    StringBuilder saleStatisticsCode = new StringBuilder();
    saleStatisticsCode.append(OrderStatisticsElementConstant.NORMAL_GOODS).append("+")
        .append(OrderStatisticsElementConstant.COMPLIMENTARY_GOODS);
    saleStatisticsModelVo.setSaleStatisticsCode(saleStatisticsCode.toString());
    saleStatisticsModelVo.setSaleStatisticsStatus(OrderStatisticsElementTypeEnum.SHOW.getKey());
    saleStatisticsModelVo.setSaleStatisticsName(SALE_STATISTICS_NAME);
    return saleStatisticsModelVo;

  }
}
