package com.biz.crm.dms.business.order.feerate.local.service.strategy;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsOptimalFeePoolRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.enums.DemensionEnum;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.service.DmsFeeRateVoService;
import com.biz.crm.dms.business.order.feerate.sdk.strategy.DemensionStrategy;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description: 生效维度（客户）
 * @author: rentao
 * @date: 2022/6/8 15:35
 */
@Service
@Slf4j
public class DemensionCustomerStrategy implements DemensionStrategy {

  @Autowired(required = false)
  private DmsFeeRateVoService dmsFeeRateVoService;

  @Override
  public Integer getDemensionCode() {
    return DemensionEnum.CUSTOMER.getKey();
  }

  @Override
  public String getDemensionName() {
    return DemensionEnum.CUSTOMER.getValue();
  }

  @Override
  public int getDemensionIndex() {
    return 0;
  }

  @Override
  public List<DmsFeeRateVo> getByDemension(DmsOptimalFeePoolRateDto dmsOptimalFeePoolRateDto, FeeTypeEnum feeTypeEnum) {
    Validate.notNull(dmsOptimalFeePoolRateDto,"参数不存在！");
    if(StringUtils.isBlank(dmsOptimalFeePoolRateDto.getCustomerCode())){
      return null;
    }
    DmsFeeRateDto dmsFeeRateDto = new DmsFeeRateDto();
    dmsFeeRateDto.setFeeType(feeTypeEnum.getKey());
    dmsFeeRateDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dmsFeeRateDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    dmsFeeRateDto.setBusinessCode(dmsOptimalFeePoolRateDto.getCustomerCode());
    dmsFeeRateDto.setDemension(DemensionEnum.CUSTOMER.getKey());
    dmsFeeRateDto.setTenantCode(TenantUtils.getTenantCode());
    dmsFeeRateDto.setFeeStatisticsCode(dmsOptimalFeePoolRateDto.getFeeStatisticsCode());
    dmsFeeRateDto.setSaleStatisticsCode(dmsOptimalFeePoolRateDto.getSaleStatisticsCode());
    return this.dmsFeeRateVoService.findByDmsFeeRateDto(dmsFeeRateDto);
  }

  @Override
  public void validateDmsFeeRate(DmsFeeRateDto dmsFeeRateDto) {
    Validate.notBlank(dmsFeeRateDto.getBusinessCode(), "客户编码不能为空");
    Validate.notBlank(dmsFeeRateDto.getBusinessName(), "客户名称不能为空");
  }
}
