package com.biz.crm.dms.business.order.feerate.local.service.strategy;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.service.DmsFeeRateVerificationService;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderVerificationStrategy;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * @description: 费用池使用比例校验 注册
 * @author: rentao
 * @date: 2021/12/30 14:35
 */
@Service
@Slf4j
public class DmsFeePoolOrderVerificationStrategyImpl implements OrderVerificationStrategy {

  @Autowired(required = false) private DmsFeeRateVerificationService dmsFeeRateVerificationService;

  @Override
  public List<OrderValidationProcessNodeEnum> processNodeEnums() {
    return Lists.newArrayList(OrderValidationProcessNodeEnum.FOUR);
  }

  /**
   * 对哪些订单类型做校验
   *
   * @return List<OrderTypeEnum>
   */
  @Override
  public List<OrderTypeEnum> orderTypeEnums() {
    return Collections.singletonList(OrderTypeEnum.STANDARD);
  }

  /**
   * 是否设定为必须校验项（不接受页面选择是否开启）
   *
   * @return Boolean true 是，false 否
   */
  @Override
  public Boolean required() {
    return Boolean.FALSE;
  }

  /**
   * 订单校验描述（费用池使用比例校验）
   *
   * @author rentao
   */
  @Override
  public String title() {
    return "费用池使用比例校验";
  }

  /**
   * 费用池使用比例校验
   *
   * @param orderVerificationContext
   * @author rento
   * @date
   */
  @Override
  public void execute(OrderVerificationContext orderVerificationContext) {
    this.dmsFeeRateVerificationService.handleValidateFeeRateOrderRate(orderVerificationContext, FeeTypeEnum.FEE_POOL);
  }
}
