/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.feerate.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.order.feerate.local.entity.DmsFeeRate;
import com.biz.crm.dms.business.order.feerate.local.repository.DmsFeeRateRepository;
import com.biz.crm.dms.business.order.feerate.local.service.DmsFeeRateService;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsOptimalFeePoolRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.event.FeeRateEventListener;
import com.biz.crm.dms.business.order.feerate.sdk.strategy.DemensionStrategy;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="dmsFeeRateService")
public class DmsFeeRateServiceImpl
implements DmsFeeRateService {
    private static final Logger log = LoggerFactory.getLogger(DmsFeeRateServiceImpl.class);
    @Autowired(required=false)
    private DmsFeeRateRepository dmsFeeRateRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<FeeRateEventListener> feeRateEventListeners;
    @Autowired(required=false)
    private List<DemensionStrategy> demensionStrategies;
    public static final String FEE_POOL_DEFAULT_ELEMENT_NAME = "\u8d39\u7528\u6c60\u9ed8\u8ba4";

    @Override
    public Page<DmsFeeRate> findByConditions(Pageable pageable, DmsFeeRateDto dmsFeeRateDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dmsFeeRateDto)) {
            dmsFeeRateDto = new DmsFeeRateDto();
        }
        return this.dmsFeeRateRepository.findByConditions(pageable, dmsFeeRateDto);
    }

    @Override
    public DmsFeeRate findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (DmsFeeRate)((Object)this.dmsFeeRateRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public DmsFeeRate create(DmsFeeRateDto dmsFeeRateDto) {
        this.createValidate(dmsFeeRateDto);
        DmsFeeRate dmsFeeRate = (DmsFeeRate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dmsFeeRateDto, DmsFeeRate.class, HashSet.class, ArrayList.class, new String[0]));
        this.dmsFeeRateRepository.save((Object)dmsFeeRate);
        dmsFeeRateDto.setId(dmsFeeRate.getId());
        if (!CollectionUtils.isEmpty(this.feeRateEventListeners)) {
            DmsFeeRateVo dmsFeeRateVo = (DmsFeeRateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dmsFeeRateDto, DmsFeeRateVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.feeRateEventListeners.forEach(listener -> listener.onCreate(dmsFeeRateVo));
        }
        return dmsFeeRate;
    }

    @Override
    @Transactional
    public DmsFeeRate update(DmsFeeRateDto dmsFeeRateDto) {
        this.updateValidate(dmsFeeRateDto);
        DmsFeeRate dmsFeeRate = (DmsFeeRate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dmsFeeRateDto, DmsFeeRate.class, HashSet.class, ArrayList.class, new String[0]));
        this.dmsFeeRateRepository.updateById((Object)dmsFeeRate);
        if (!CollectionUtils.isEmpty(this.feeRateEventListeners)) {
            DmsFeeRateVo dmsFeeRateVo = (DmsFeeRateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dmsFeeRateDto, DmsFeeRateVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.feeRateEventListeners.forEach(listener -> listener.onUpdate(dmsFeeRateVo));
        }
        return dmsFeeRate;
    }

    @Override
    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.dmsFeeRateRepository.removeByIds(ids);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List entities = this.dmsFeeRateRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.dmsFeeRateRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
        if (!CollectionUtils.isEmpty(this.feeRateEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, DmsFeeRate.class, DmsFeeRateVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.feeRateEventListeners.forEach(listener -> listener.onEnable(voList));
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List entities = this.dmsFeeRateRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.dmsFeeRateRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        if (!CollectionUtils.isEmpty(this.feeRateEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, DmsFeeRate.class, DmsFeeRateVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.feeRateEventListeners.forEach(listener -> listener.onDisable(voList));
        }
    }

    private void createValidate(DmsFeeRateDto dmsFeeRateDto) {
        this.baseValidate(dmsFeeRateDto);
        dmsFeeRateDto.setId(null);
        dmsFeeRateDto.setTenantCode(TenantUtils.getTenantCode());
        dmsFeeRateDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dmsFeeRateDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List<DmsFeeRateVo> dmsFeeRates = this.getDmsFeeRate(dmsFeeRateDto);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(dmsFeeRates), (String)"\u8d39\u7528\u7ef4\u5ea6\u5df2\u5b58\u5728\u6570\u636e\u3002", (Object[])new Object[0]);
    }

    private void updateValidate(DmsFeeRateDto dmsFeeRateDto) {
        this.baseValidate(dmsFeeRateDto);
        Validate.notBlank((CharSequence)dmsFeeRateDto.getId(), (String)"\u8d39\u7528\u6bd4\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<DmsFeeRateVo> dmsFeeRates = this.getDmsFeeRate(dmsFeeRateDto);
        if (!CollectionUtils.isEmpty(dmsFeeRates)) {
            Validate.isTrue((dmsFeeRates.size() < 2 ? 1 : 0) != 0, (String)"\u8d39\u7528\u7ef4\u5ea6\u5df2\u5b58\u5728\u6570\u636e", (Object[])new Object[0]);
            Validate.isTrue((dmsFeeRates.size() == 1 && dmsFeeRateDto.getId().equals(dmsFeeRates.get(0).getId()) ? 1 : 0) != 0, (String)"\u8d39\u7528\u7ef4\u5ea6\u5df2\u5b58\u5728\u6570\u636e", (Object[])new Object[0]);
        }
    }

    private void baseValidate(DmsFeeRateDto dmsFeeRate) {
        Validate.notNull((Object)dmsFeeRate, (String)"\u8d39\u7528\u6bd4\u4f8b\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dmsFeeRate.getDemension(), (String)"\u8d39\u7528\u6bd4\u4f8b\u751f\u6548\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dmsFeeRate.getFeeStatisticsCode(), (String)"\u8d39\u7528\u6bd4\u4f8b\u8d39\u7528\u7edf\u8ba1\u8303\u56f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dmsFeeRate.getFeeStatisticsName(), (String)"\u8d39\u7528\u6bd4\u4f8b\u8d39\u7528\u7edf\u8ba1\u8303\u56f4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dmsFeeRate.getFeeType(), (String)"\u8d39\u7528\u6bd4\u4f8b\u8d39\u6bd4\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)FeeTypeEnum.getByKey((Integer)dmsFeeRate.getFeeType()), (String)"\u8d39\u6bd4\u7c7b\u578b\u4f20\u5165\u6709\u8bef", (Object[])new Object[0]);
        Validate.notNull((Object)dmsFeeRate.getRate(), (String)"\u8d39\u7528\u6bd4\u4f8b \uff08%\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.demensionStrategies) ? 1 : 0) != 0, (String)"\u751f\u6548\u7ef4\u5ea6\u6ca1\u6709\u7b56\u7565\u5b9e\u73b0\uff01", (Object[])new Object[0]);
        List strategies = this.demensionStrategies.stream().filter(demensionStrategy -> demensionStrategy.getDemensionCode().equals(dmsFeeRate.getDemension())).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(strategies) ? 1 : 0) != 0, (String)"\u751f\u6548\u7ef4\u5ea6\u4f20\u5165\u6570\u636e\u6709\u8bef\uff01", (Object[])new Object[0]);
        if (FeeTypeEnum.ENTIRE_ORDER.getKey().equals(dmsFeeRate.getFeeType())) {
            Validate.notBlank((CharSequence)dmsFeeRate.getSaleStatisticsCode(), (String)"\u8d39\u7528\u6bd4\u4f8b\u9500\u552e\u989d\u7edf\u8ba1\u8303\u56f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dmsFeeRate.getSaleStatisticsName(), (String)"\u8d39\u7528\u6bd4\u4f8b\u9500\u552e\u989d\u7edf\u8ba1\u8303\u56f4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        } else {
            dmsFeeRate.setSaleStatisticsCode("FeePoolDefaultElement");
            dmsFeeRate.setSaleStatisticsName(FEE_POOL_DEFAULT_ELEMENT_NAME);
        }
        DemensionStrategy demensionStrategy2 = (DemensionStrategy)strategies.get(0);
        dmsFeeRate.setDemensionName(demensionStrategy2.getDemensionName());
        demensionStrategy2.validateDmsFeeRate(dmsFeeRate);
    }

    private List<DmsFeeRateVo> getDmsFeeRate(DmsFeeRateDto dmsFeeRateDto) {
        List strategies = this.demensionStrategies.stream().filter(demensionStrategy -> demensionStrategy.getDemensionCode().equals(dmsFeeRateDto.getDemension())).collect(Collectors.toList());
        DemensionStrategy demensionStrategy2 = (DemensionStrategy)strategies.get(0);
        DmsOptimalFeePoolRateDto dmsOptimalFeePoolRateDto = new DmsOptimalFeePoolRateDto();
        dmsOptimalFeePoolRateDto.setSaleStatisticsCode(dmsFeeRateDto.getSaleStatisticsCode());
        dmsOptimalFeePoolRateDto.setFeeStatisticsCode(dmsFeeRateDto.getFeeStatisticsCode());
        dmsOptimalFeePoolRateDto.setBusinessCode(dmsFeeRateDto.getBusinessCode());
        FeeTypeEnum feeTypeEnum = FeeTypeEnum.getByKey((Integer)dmsFeeRateDto.getFeeType());
        return demensionStrategy2.getByDemension(dmsOptimalFeePoolRateDto, feeTypeEnum);
    }
}

