/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.feerate.local.service.internal;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsElementRegister;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsService;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsOptimalFeePoolRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.service.DmsFeeRateVerificationService;
import com.biz.crm.dms.business.order.feerate.sdk.strategy.DemensionStrategy;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DmsFeeRateVerificationServiceImpl
implements DmsFeeRateVerificationService {
    private static final Logger log = LoggerFactory.getLogger(DmsFeeRateVerificationServiceImpl.class);
    @Autowired(required=false)
    private OrderStatisticsService orderStatisticsService;
    @Autowired(required=false)
    private List<OrderStatisticsElementRegister> orderStatisticsElementRegisterList;
    @Autowired(required=false)
    private List<DemensionStrategy> demensionStrategies;

    public void handleValidateFeeRateOrderRate(OrderVerificationContext orderVerificationContext, FeeTypeEnum feeTypeEnum) {
        Validate.notNull((Object)orderVerificationContext, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        OrderDto orderDto = orderVerificationContext.getOrderDto();
        Validate.notNull((Object)feeTypeEnum, (String)"\u8d39\u6bd4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)orderDto, (String)"\u8d39\u6bd4\u6821\u9a8c\u65f6\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<DmsFeeRateVo> dmsFeeRateVos = this.getFeeRateVo(orderDto, feeTypeEnum);
        for (DmsFeeRateVo dmsFeeRateVo : dmsFeeRateVos) {
            BigDecimal rate;
            BigDecimal actualRate;
            String saleStatisticsCodes = dmsFeeRateVo.getSaleStatisticsCode();
            String feeStatisticsCodes = dmsFeeRateVo.getFeeStatisticsCode();
            HashSet saleStatisticsCodSet = Sets.newHashSet((Object[])StringUtils.split((String)saleStatisticsCodes, (String)"+"));
            HashSet feeStatisticsCodeSet = Sets.newHashSet((Object[])StringUtils.split((String)feeStatisticsCodes, (String)"+"));
            List<BigDecimal> saleCountMoneys = this.getFeeCountMoney(saleStatisticsCodSet, orderVerificationContext);
            List<BigDecimal> feeCountMoneys = this.getFeeCountMoney(feeStatisticsCodeSet, orderVerificationContext);
            BigDecimal saleCountMoney = this.orderStatisticsService.getFeeCount(saleCountMoneys);
            BigDecimal feeCountMoney = this.orderStatisticsService.getFeeCount(feeCountMoneys);
            Validate.isTrue((feeCountMoney.compareTo(actualRate = saleCountMoney.multiply(rate = dmsFeeRateVo.getRate()).divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_UP)) <= 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u6bd4\u4f8b\u8d85\u8fc7%s\u8d39\u6bd4\u8bbe\u7f6e\u6bd4\u4f8b", (Object[])new Object[]{feeTypeEnum.getValue()});
        }
    }

    private List<DmsFeeRateVo> getFeeRateVo(OrderDto orderDto, FeeTypeEnum feeTypeEnum) {
        Validate.isTrue((!CollectionUtils.isEmpty(this.demensionStrategies) ? 1 : 0) != 0, (String)"\u83b7\u53d6\u8d39\u6bd4\u662f\u751f\u6548\u7ef4\u5ea6\u6ce8\u518c\u5668\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        List demensionStrategieList = this.demensionStrategies.stream().sorted(Comparator.comparing(DemensionStrategy::getDemensionIndex)).collect(Collectors.toList());
        ArrayList<DmsFeeRateVo> dmsFeeRateVoList = new ArrayList<DmsFeeRateVo>();
        DmsOptimalFeePoolRateDto dmsOptimalFeePoolRateDto = new DmsOptimalFeePoolRateDto();
        dmsOptimalFeePoolRateDto.setBusinessCode(orderDto.getRelateCode());
        for (DemensionStrategy demensionStrategy : demensionStrategieList) {
            List dmsFeeRateVos = demensionStrategy.getByDemension(dmsOptimalFeePoolRateDto, feeTypeEnum);
            if (CollectionUtils.isEmpty((Collection)dmsFeeRateVos)) continue;
            dmsFeeRateVoList.addAll(dmsFeeRateVos);
            break;
        }
        return dmsFeeRateVoList;
    }

    private List<BigDecimal> getFeeCountMoney(Set<String> orderStatisticsCodSet, OrderVerificationContext orderVerificationContext) {
        Validate.isTrue((!CollectionUtils.isEmpty(orderStatisticsCodSet) ? 1 : 0) != 0, (String)"\u4f20\u5165\u8ba2\u5355\u7edf\u8ba1\u8303\u56f4\u8981\u7d20\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<BigDecimal> feeMoneys = new ArrayList<BigDecimal>();
        for (String orderStatisticsElementCode : orderStatisticsCodSet) {
            this.orderStatisticsElementRegisterList.forEach(orderStatisticsElementRegister -> {
                if (orderStatisticsElementRegister.getOrderStatisticsElementCode().equals(orderStatisticsElementCode)) {
                    BigDecimal feeMoney = orderStatisticsElementRegister.getFeeMoney(orderVerificationContext);
                    feeMoneys.add(feeMoney);
                }
            });
        }
        Validate.isTrue((orderStatisticsCodSet.size() == feeMoneys.size() ? 1 : 0) != 0, (String)"\u8ba1\u7b97\u91d1\u989d\uff0c\u4f20\u5165\u8ba2\u5355\u7edf\u8ba1\u8303\u56f4\u8981\u7d20\u548c\u5339\u914d\u6570\u91cf\u4e0d\u76f8\u7b49", (Object[])new Object[0]);
        return feeMoneys;
    }
}

