/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.feerate.local.service.internal;

import com.biz.crm.dms.business.order.feerate.local.entity.DmsFeeRate;
import com.biz.crm.dms.business.order.feerate.local.repository.DmsFeeRateRepository;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsOptimalFeePoolRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.service.DmsFeeRateVoService;
import com.biz.crm.dms.business.order.feerate.sdk.strategy.DemensionStrategy;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DmsFeeRateVoServiceImpl
implements DmsFeeRateVoService {
    private static final Logger log = LoggerFactory.getLogger(DmsFeeRateVoServiceImpl.class);
    @Autowired(required=false)
    private DmsFeeRateRepository dmsFeeRateRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private List<DemensionStrategy> demensionStrategies;

    public List<DmsFeeRateVo> findByDmsFeeRateDto(DmsFeeRateDto dmsFeeRateDto) {
        if (Objects.isNull(dmsFeeRateDto)) {
            return null;
        }
        List<DmsFeeRate> dmsFeeRateList = this.dmsFeeRateRepository.findByConditions(dmsFeeRateDto);
        if (CollectionUtils.isEmpty(dmsFeeRateList)) {
            return null;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(dmsFeeRateList, DmsFeeRate.class, DmsFeeRateVo.class, HashSet.class, ArrayList.class, new String[0]);
        return list;
    }

    public DmsFeeRateVo findOptimalFeeRateVoByFeeRateDto(DmsOptimalFeePoolRateDto dmsOptimalFeeRateDto) {
        Validate.notNull((Object)dmsOptimalFeeRateDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dmsOptimalFeeRateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dmsOptimalFeeRateDto.getFeeStatisticsCode(), (String)"\u8d39\u7528\u7edf\u8ba1\u8303\u56f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dmsOptimalFeeRateDto.setFeeStatisticsCode(dmsOptimalFeeRateDto.getFeeStatisticsCode().replaceAll(" ", "+"));
        return this.getFeeRateVo(dmsOptimalFeeRateDto, FeeTypeEnum.FEE_POOL);
    }

    private DmsFeeRateVo getFeeRateVo(DmsOptimalFeePoolRateDto dmsOptimalFeeRateDto, FeeTypeEnum feeTypeEnum) {
        Validate.isTrue((!CollectionUtils.isEmpty(this.demensionStrategies) ? 1 : 0) != 0, (String)"\u83b7\u53d6\u8d39\u6bd4\u662f\u751f\u6548\u7ef4\u5ea6\u6ce8\u518c\u5668\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        List demensionStrategieList = this.demensionStrategies.stream().sorted(Comparator.comparing(DemensionStrategy::getDemensionIndex)).collect(Collectors.toList());
        ArrayList dmsFeeRateVoList = new ArrayList();
        for (DemensionStrategy demensionStrategy : demensionStrategieList) {
            List dmsFeeRateVos = demensionStrategy.getByDemension(dmsOptimalFeeRateDto, feeTypeEnum);
            if (CollectionUtils.isEmpty((Collection)dmsFeeRateVos)) continue;
            dmsFeeRateVoList.addAll(dmsFeeRateVos);
            break;
        }
        Validate.isTrue((!CollectionUtils.isEmpty(dmsFeeRateVoList) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u914d\u7f6e\u8d39\u7528\u6bd4\u4f8b", (Object[])new Object[0]);
        return (DmsFeeRateVo)dmsFeeRateVoList.get(0);
    }
}

