package com.biz.crm.dms.business.order.feerate.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.feerate.local.service.DmsFeeRateDemensionService;
import com.biz.crm.dms.business.order.feerate.local.service.DmsFeeStatisticsService;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateDemensionVo;
import com.biz.crm.dms.business.order.feerate.sdk.vo.FeeStatisticsModelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: some desc
 * @author: rentao
 * @date: 2022/6/8 16:54
 */
@RestController
@RequestMapping(value = {"/v1/feeRateDemension/feeRateDemension"})
@Slf4j
@Api(tags = "费用比例生效范围:feeRateDemension:费用比例生效范围")
public class DmsFeeRateDemensionController {

  @Autowired(required = false)
  private DmsFeeRateDemensionService dmsFeeRateDemensionService;

  /**
   * 费用销售范围列表
   *
   * @param
   */
  @ApiOperation(value = "费用销售范围列表")
  @GetMapping("/findByConditions")
  public Result<List<DmsFeeRateDemensionVo>> findByConditions() {
    return Result.ok(this.dmsFeeRateDemensionService.findByConditions());
  }
}
