package com.biz.crm.dms.business.order.feerate.local.controller;

import com.biz.crm.business.common.sdk.model.Result;

import com.biz.crm.dms.business.order.feerate.local.service.DmsFeeStatisticsService;
import com.biz.crm.dms.business.order.feerate.sdk.vo.FeeStatisticsModelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 费用销售范围:FeeStatisticsModelVo:费用销售范围
 * @author: rentao
 * @date: 2022/1/3 21:25
 */
@RestController
@RequestMapping(value = {"/v1/feeStatistics/feeStatistics"})
@Slf4j
@Api(tags = "费用销售范围:FeeStatisticsModelVo:费用销售范围")
public class DmsFeeStatisticsController {

  @Autowired(required = false) private DmsFeeStatisticsService dmsFeeStatisticsService;

  /**
   * 费用销售范围列表
   *
   * @param
   */
  @ApiOperation(value = "费用销售范围列表")
  @GetMapping("/findByConditions")
  public Result<List<FeeStatisticsModelVo>> findByConditions(@RequestParam("feeStatisticsType") @ApiParam(name = "feeStatisticsType" , required = true , value = "费比类型  0 费用池 1 整单 ") Integer feeStatisticsType) {
    return Result.ok(this.dmsFeeStatisticsService.findByConditions(feeStatisticsType));
  }
}
