package com.biz.crm.dms.business.order.feerate.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.dms.business.order.feerate.local.entity.DmsFeeRate;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 费用比例(DmsFeeRate)mybatis
 *
 * @author rentao
 * @since 2021-12-29 17:53:58
 */
public interface DmsFeeRateMapper extends BaseMapper<DmsFeeRate> {

  /**
   * 分页查询所有数据
   *
   * @param page
   * @param dmsFeeRate
   * @author rentao
   * @date
   */
  public Page<DmsFeeRate> findByConditions(
      @Param("page") Page<DmsFeeRate> page, @Param("dto") DmsFeeRateDto dmsFeeRateDto);

  /**
   * 条件查询所有数据
   *
   * @param dmsFeeRateDto
   * @author rentao
   * @date
   */
  public List<DmsFeeRate> findByConditions(@Param("dto") DmsFeeRateDto dmsFeeRateDto);
}
