package com.biz.crm.dms.business.order.feerate.local.service;

import com.biz.crm.dms.business.order.feerate.local.entity.DmsFeeRate;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 费用比例(DmsFeeRate)service
 *
 * @author rentao
 * @since 2021-12-29 17:53:57
 */
public interface DmsFeeRateService {

  /**
   * 分页查询所有数据
   *
   * @param pageable
   * @param dmsFeeRateDto
   * @author rentao
   * @date
   */
  Page<DmsFeeRate> findByConditions(Pageable pageable, DmsFeeRateDto dmsFeeRateDto);

  /**
   * 通过主键查询单条数据
   *
   * @param id
   * @author rentao
   * @date
   */
  DmsFeeRate findById(String id);

  /**
   * 新增数据
   *
   * @param dmsFeeRateDto
   * @author rentao
   * @date
   */
  DmsFeeRate create(DmsFeeRateDto dmsFeeRateDto);

  /**
   * 编辑数据
   *
   * @param dmsFeeRateDto
   * @author rentao
   * @date
   */
  DmsFeeRate update(DmsFeeRateDto dmsFeeRateDto);

  /**
   * 批量删除
   *
   * @param ids
   * @author rentao
   */
  void delete(List<String> ids);

  /**
   * 启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);
}
