package com.biz.crm.dms.business.order.feerate.local.service.internal;

import com.biz.crm.dms.business.order.feerate.local.context.feerateelement.FeeStatisticsContext;
import com.biz.crm.dms.business.order.feerate.local.service.DmsFeeStatisticsService;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.vo.FeeStatisticsModelVo;
import java.util.List;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 费用销售范围
 * @author: rentao
 * @date: 2022/1/3 21:38
 */
@Service
@Slf4j
public class DmsFeeStatisticsServiceImpl implements DmsFeeStatisticsService {

  @Autowired(required = false) private FeeStatisticsContext feeStatisticsContext;

  /**
   * 拿到费用销售范围
   *
   * @author rentao
   * @date
   */
  @Override
  public List<FeeStatisticsModelVo> findByConditions(Integer feeStatisticsType) {
    Validate.notNull(feeStatisticsType,"请传入费用销售范围类型");
    FeeTypeEnum feeTypeEnum = FeeTypeEnum.getByKey(feeStatisticsType);
    Validate.notNull(feeTypeEnum,"传入类型不存在");
    List<FeeStatisticsModelVo> feeStatisticsModelVos = feeStatisticsContext.getAllConfig();
    if(!CollectionUtils.isEmpty(feeStatisticsModelVos)){
      return feeStatisticsModelVos.stream().filter(
          feeStatisticsModelVo -> feeStatisticsModelVo.getFeeStatisticsType()
              .equals(feeStatisticsType)).collect(
          Collectors.toList());
    }
    return null ;
  }
}
