package com.biz.crm.dms.business.order.feerate.local.service.register.salestatistics;

import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.constant.OrderStatisticsElementConstant;
import com.biz.crm.dms.business.order.feerate.sdk.enums.OrderStatisticsElementTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.register.SaleStatisticsRegister;
import com.biz.crm.dms.business.order.feerate.sdk.vo.SaleStatisticsModelVo;
import org.springframework.stereotype.Service;

/**
 * @description: 费用池默认组合注册器实现
 * @author: rentao
 * @date: 2022/1/19 10:34
 */
@Service
public class FeePoolDefaultSaleStatisticsRegisterImpl implements SaleStatisticsRegister {

  private static final Integer INDEX_CODE = 4;

  private static final String SALE_STATISTICS_NAME = "费用池默认";

  @Override
  public SaleStatisticsModelVo onRequestSaleStatisticsModelVo() {
    SaleStatisticsModelVo saleStatisticsModelVo = new SaleStatisticsModelVo();
    saleStatisticsModelVo.setSaleStatisticsSort(INDEX_CODE);
    saleStatisticsModelVo.setSaleStatisticsCode(OrderStatisticsElementConstant.FEE_POOL_DEFAULT_ELEMENT);
    saleStatisticsModelVo.setSaleStatisticsName(SALE_STATISTICS_NAME);
    saleStatisticsModelVo.setSaleStatisticsStatus(OrderStatisticsElementTypeEnum.HIDE.getKey());
    return saleStatisticsModelVo;
  }
}
