package com.biz.crm.dms.business.order.feerate.local.service.register.salestatistics;

import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.constant.OrderStatisticsElementConstant;
import com.biz.crm.dms.business.order.feerate.sdk.enums.OrderStatisticsElementTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.register.SaleStatisticsRegister;
import com.biz.crm.dms.business.order.feerate.sdk.vo.SaleStatisticsModelVo;
import org.springframework.stereotype.Service;

/**
 * @description: 本品 组合注册器实现
 * @author: rentao
 * @date: 2022/1/17 14:11
 */
@Service
public class NormalSaleStatisticsRegisterImpl implements SaleStatisticsRegister {

  private static final Integer INDEX_CODE = 1;

  private static final String SALE_STATISTICS_NAME = "本品";

  @Override
  public SaleStatisticsModelVo onRequestSaleStatisticsModelVo() {
    SaleStatisticsModelVo saleStatisticsModelVo = new SaleStatisticsModelVo();
    saleStatisticsModelVo.setSaleStatisticsSort(INDEX_CODE);
    saleStatisticsModelVo.setSaleStatisticsCode(OrderStatisticsElementConstant.NORMAL_GOODS);
    saleStatisticsModelVo.setSaleStatisticsName(SALE_STATISTICS_NAME);
    saleStatisticsModelVo.setSaleStatisticsStatus(OrderStatisticsElementTypeEnum.SHOW.getKey());
    return saleStatisticsModelVo;
  }
}
