package com.biz.crm.dms.business.order.feerate.local.service.strategy;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsOptimalFeePoolRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.enums.DemensionEnum;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.service.DmsFeeRateVoService;
import com.biz.crm.dms.business.order.feerate.sdk.strategy.DemensionStrategy;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description: 生效维度（组织）
 * @author: rentao
 * @date: 2022/6/8 15:34
 */
@Service
@Slf4j
public class DemensionOrgStrategy implements DemensionStrategy {
  @Autowired(required = false)
  private DmsFeeRateVoService dmsFeeRateVoService;
  @Autowired
  private CustomerVoService customerVoService;

  @Override
  public Integer getDemensionCode() {
    return DemensionEnum.ORG.getKey();
  }

  @Override
  public String getDemensionName() {
    return DemensionEnum.ORG.getValue();
  }

  @Override
  public int getDemensionIndex() {
    return 1;
  }

  @Override
  public List<DmsFeeRateVo> getByDemension(DmsOptimalFeePoolRateDto orderDto, FeeTypeEnum feeTypeEnum) {
    Validate.notNull(orderDto,"订单参数不存在！");
    String businessCode = orderDto.getBusinessCode();
    if (StringUtils.isNotBlank(orderDto.getCustomerCode())) {
      CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, orderDto.getCustomerCode());
      Validate.notNull(customerVo, "客户不存在");
      businessCode = customerVo.getOrgCode();
    }
    if(StringUtils.isBlank(businessCode)){
      return null;
    }
    DmsFeeRateDto dmsFeeRateDto = new DmsFeeRateDto();
    dmsFeeRateDto.setFeeType(feeTypeEnum.getKey());
    dmsFeeRateDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dmsFeeRateDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    dmsFeeRateDto.setDemension(DemensionEnum.ORG.getKey());
    dmsFeeRateDto.setBusinessCode(businessCode);
    dmsFeeRateDto.setFeeStatisticsCode(orderDto.getFeeStatisticsCode());
    dmsFeeRateDto.setSaleStatisticsCode(orderDto.getSaleStatisticsCode());
    return this.dmsFeeRateVoService.findByDmsFeeRateDto(dmsFeeRateDto);
  }

  @Override
  public void validateDmsFeeRate(DmsFeeRateDto dmsFeeRateDto) {
    Validate.notBlank(dmsFeeRateDto.getBusinessCode(), "组织编码不能为空");
    Validate.notBlank(dmsFeeRateDto.getBusinessName(), "组织名称不能为空");
  }
}
