/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.feerate.local.service.internal;

import com.biz.crm.dms.business.order.feerate.local.service.DmsFeeRateDemensionService;
import com.biz.crm.dms.business.order.feerate.sdk.strategy.DemensionStrategy;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateDemensionVo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DmsFeeRateDemensionServiceImpl
implements DmsFeeRateDemensionService {
    private static final Logger log = LoggerFactory.getLogger(DmsFeeRateDemensionServiceImpl.class);
    @Autowired(required=false)
    private List<DemensionStrategy> demensionStrategies;

    @Override
    public List<DmsFeeRateDemensionVo> findByConditions() {
        if (CollectionUtils.isEmpty(this.demensionStrategies)) {
            return null;
        }
        ArrayList<DmsFeeRateDemensionVo> list = new ArrayList<DmsFeeRateDemensionVo>();
        List demensionStrategieList = this.demensionStrategies.stream().sorted(Comparator.comparing(DemensionStrategy::getDemensionIndex)).collect(Collectors.toList());
        for (DemensionStrategy demensionStrategy : demensionStrategieList) {
            DmsFeeRateDemensionVo dmsFeeRateDemensionVo = new DmsFeeRateDemensionVo();
            dmsFeeRateDemensionVo.setDemension(demensionStrategy.getDemensionCode());
            dmsFeeRateDemensionVo.setDemensionName(demensionStrategy.getDemensionName());
            dmsFeeRateDemensionVo.setDemensonIndex(Integer.valueOf(demensionStrategy.getDemensionIndex()));
            list.add(dmsFeeRateDemensionVo);
        }
        return list;
    }
}

