/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.feerate.local.service.strategy;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsOptimalFeePoolRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.enums.DemensionEnum;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.service.DmsFeeRateVoService;
import com.biz.crm.dms.business.order.feerate.sdk.strategy.DemensionStrategy;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DemensionCustomerStrategy
implements DemensionStrategy {
    private static final Logger log = LoggerFactory.getLogger(DemensionCustomerStrategy.class);
    @Autowired(required=false)
    private DmsFeeRateVoService dmsFeeRateVoService;

    public Integer getDemensionCode() {
        return DemensionEnum.CUSTOMER.getKey();
    }

    public String getDemensionName() {
        return DemensionEnum.CUSTOMER.getValue();
    }

    public int getDemensionIndex() {
        return 0;
    }

    public List<DmsFeeRateVo> getByDemension(DmsOptimalFeePoolRateDto dmsOptimalFeePoolRateDto, FeeTypeEnum feeTypeEnum) {
        Validate.notNull((Object)dmsOptimalFeePoolRateDto, (String)"\u53c2\u6570\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dmsOptimalFeePoolRateDto.getCustomerCode())) {
            return null;
        }
        DmsFeeRateDto dmsFeeRateDto = new DmsFeeRateDto();
        dmsFeeRateDto.setFeeType(feeTypeEnum.getKey());
        dmsFeeRateDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dmsFeeRateDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dmsFeeRateDto.setBusinessCode(dmsOptimalFeePoolRateDto.getCustomerCode());
        dmsFeeRateDto.setDemension(DemensionEnum.CUSTOMER.getKey());
        dmsFeeRateDto.setTenantCode(TenantUtils.getTenantCode());
        dmsFeeRateDto.setFeeStatisticsCode(dmsOptimalFeePoolRateDto.getFeeStatisticsCode());
        dmsFeeRateDto.setSaleStatisticsCode(dmsOptimalFeePoolRateDto.getSaleStatisticsCode());
        return this.dmsFeeRateVoService.findByDmsFeeRateDto(dmsFeeRateDto);
    }

    public void validateDmsFeeRate(DmsFeeRateDto dmsFeeRateDto) {
        Validate.notBlank((CharSequence)dmsFeeRateDto.getBusinessCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dmsFeeRateDto.getBusinessName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

