/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.feerate.local.service.strategy;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsFeeRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.dto.DmsOptimalFeePoolRateDto;
import com.biz.crm.dms.business.order.feerate.sdk.enums.DemensionEnum;
import com.biz.crm.dms.business.order.feerate.sdk.enums.FeeTypeEnum;
import com.biz.crm.dms.business.order.feerate.sdk.service.DmsFeeRateVoService;
import com.biz.crm.dms.business.order.feerate.sdk.strategy.DemensionStrategy;
import com.biz.crm.dms.business.order.feerate.sdk.vo.DmsFeeRateVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DemensionOrgStrategy
implements DemensionStrategy {
    private static final Logger log = LoggerFactory.getLogger(DemensionOrgStrategy.class);
    @Autowired(required=false)
    private DmsFeeRateVoService dmsFeeRateVoService;
    @Autowired
    private CustomerVoService customerVoService;

    public Integer getDemensionCode() {
        return DemensionEnum.ORG.getKey();
    }

    public String getDemensionName() {
        return DemensionEnum.ORG.getValue();
    }

    public int getDemensionIndex() {
        return 1;
    }

    public List<DmsFeeRateVo> getByDemension(DmsOptimalFeePoolRateDto orderDto, FeeTypeEnum feeTypeEnum) {
        Validate.notNull((Object)orderDto, (String)"\u8ba2\u5355\u53c2\u6570\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        String businessCode = orderDto.getBusinessCode();
        if (StringUtils.isNotBlank((CharSequence)orderDto.getCustomerCode())) {
            CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, orderDto.getCustomerCode());
            Validate.notNull((Object)customerVo, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            businessCode = customerVo.getOrgCode();
        }
        if (StringUtils.isBlank((CharSequence)businessCode)) {
            return null;
        }
        DmsFeeRateDto dmsFeeRateDto = new DmsFeeRateDto();
        dmsFeeRateDto.setFeeType(feeTypeEnum.getKey());
        dmsFeeRateDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dmsFeeRateDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dmsFeeRateDto.setDemension(DemensionEnum.ORG.getKey());
        dmsFeeRateDto.setBusinessCode(businessCode);
        dmsFeeRateDto.setFeeStatisticsCode(orderDto.getFeeStatisticsCode());
        dmsFeeRateDto.setSaleStatisticsCode(orderDto.getSaleStatisticsCode());
        return this.dmsFeeRateVoService.findByDmsFeeRateDto(dmsFeeRateDto);
    }

    public void validateDmsFeeRate(DmsFeeRateDto dmsFeeRateDto) {
        Validate.notBlank((CharSequence)dmsFeeRateDto.getBusinessCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dmsFeeRateDto.getBusinessName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

