package com.biz.crm.dms.business.order.feerate.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 费用比例最优查询dto
 * @author: rentao
 * @date: 2022/3/1 14:13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DmsOptimalFeeRateDto", description = "费用比例最优查询dto")
public class DmsOptimalFeePoolRateDto {

  /** 组织编码*/
  @ApiModelProperty(name = "businessCode", value = "组织编码 生效维度为 0 客户 必填")
  private String businessCode;

  @ApiModelProperty(name = "customerCode", value = "客户编码")
  private String customerCode;

  /** 费用统计范围编码 */
  @ApiModelProperty(name = "feeStatisticsCode", value = "费用统计范围编码（OrderStatisticsElementConstant）常量", required = true)
  private String feeStatisticsCode;

  /** 费用统计范围编码 */
  @ApiModelProperty(name = "saleStatisticsCode", value = "销售额统计范围编码（OrderStatisticsElementConstant）常量", required = true)
  private String saleStatisticsCode;
}
