package com.biz.crm.dms.business.order.feerate.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 生效维度 0 客户 1 组织
 * @author: rentao
 * @date: 2021/12/30 10:15
 */
public enum DemensionEnum {


  CUSTOMER(0,"0", "客户","1"),
  ORG(1, "1","组织","2");

  private Integer key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  DemensionEnum(Integer key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public Integer getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }
  /**
   * 通过key获取 FeeTypeEnum
   *
   * @param key
   * @return
   */
  public static DemensionEnum getByKey(Integer key) {
    return Arrays
        .stream(DemensionEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }
  /**
   * 通过dictCode获取 FeeTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static DemensionEnum getByDictCode(String dictCode) {
    return Arrays.stream(DemensionEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
        .findFirst().orElse(null);
  }
}
