package com.biz.crm.dms.business.order.feerate.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 订单行要素状态
 * @author: rentao
 * @date: 2022/1/19 9:58
 */
public enum OrderStatisticsElementTypeEnum {

  SHOW("1", "1", "展示", "1"),
  HIDE("2", "2", "隐藏", "2"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  OrderStatisticsElementTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 OrderStatisticsElementTypeEnum
   *
   * @param key
   * @return
   */
  public static OrderStatisticsElementTypeEnum getByKey(String key) {
    return Arrays.stream(OrderStatisticsElementTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

}
