package com.biz.crm.dms.business.order.feerate.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 费用池统计范围模型Vo
 * @author: rentao
 * @date: 2021/12/30 18:17
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeeStatisticsModelVo", description = "费用池统计范围模型Vo")
public class FeeStatisticsModelVo {

  /** 费用统计范围编码 */
  @ApiModelProperty(name = "feeStatisticsCode", value = "费用统计范围编码", required = true)
  private String feeStatisticsCode;

  /** 费用统计范围名称 */
  @ApiModelProperty(name = "feeStatisticsCode", value = "费比类型 0 费用池 1 整单", required = true)
  private String feeStatisticsName;

  /** 费比类型 0 费用池 1 整单 可扩展需保证唯一*/
  @ApiModelProperty(name = "feeStatisticsCode", value = "费用统计范围类型", required = true)
  private Integer feeStatisticsType;

  /** 费比状态 1 展示 2 隐藏 */
  @ApiModelProperty(name = "feeStatisticsStatus", value = "费用统计范围状态", required = true)
  private String feeStatisticsStatus;

  /** 费用统计范围排序 */
  @ApiModelProperty(name = "feeStatisticsSort", value = "费用统计范围排序", required = true)
  private Integer feeStatisticsSort;
}
